/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.item.grenades;

import javax.annotation.Nullable;
import me.xjqsh.lesraisinsadd.common.data.IMetaHolder;
import me.xjqsh.lesraisinsadd.common.data.grenades.ThrowableMeta;
import me.xjqsh.lesraisinsadd.entity.throwable.ThrowableItemEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class ThrowableItem<T extends ThrowableMeta>
extends Item
implements IMetaHolder<T> {
    private final ThrowableEntityFactory<T> factory;
    private T meta;

    public ThrowableItem(Item.Properties properties, ThrowableEntityFactory<T> factory) {
        super(properties);
        this.factory = factory;
    }

    @Override
    public void setMeta(T meta) {
        this.meta = meta;
    }

    @Override
    public T getMeta() {
        return this.meta;
    }

    @Override
    public String getPath() {
        return "throwables";
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return ((ThrowableMeta)this.meta).getMaxCookTime();
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!worldIn.func_201670_d() && this.canCook()) {
            ItemStack copy = stack.func_77946_l();
            if (!(entityLiving instanceof PlayerEntity) || !((PlayerEntity)entityLiving).func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ThrowableItemEntity<T> grenade = this.create(worldIn, entityLiving, 0, this);
            grenade.setItem(copy);
            grenade.onDeath();
            grenade.func_70106_y();
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int duration;
        if (!worldIn.func_201670_d() && (duration = this.func_77626_a(stack) - timeLeft) >= 5) {
            ItemStack copy = stack.func_77946_l();
            if (!(entityLiving instanceof PlayerEntity) || !((PlayerEntity)entityLiving).func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ThrowableItemEntity<T> grenade = this.create(worldIn, entityLiving, duration, this);
            grenade.setItem(copy);
            grenade.func_234612_a_((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, Math.min(1.0f, (float)duration / 20.0f) * ((ThrowableMeta)this.meta).getSpeed(), 1.5f);
            worldIn.func_217376_c(grenade);
            this.onThrown(worldIn, grenade);
        }
    }

    public ThrowableItemEntity<T> create(World world, LivingEntity entity, int useTick, ThrowableItem<T> meta) {
        return this.factory.create(world, entity, useTick, meta);
    }

    public boolean canCook() {
        return ((ThrowableMeta)this.meta).canCook();
    }

    protected void onThrown(World world, ThrowableItemEntity<T> entity) {
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return super.initCapabilities(stack, nbt);
    }

    @FunctionalInterface
    public static interface ThrowableEntityFactory<T extends ThrowableMeta> {
        public ThrowableItemEntity<T> create(World var1, LivingEntity var2, int var3, ThrowableItem<T> var4);
    }
}

