/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.entity.throwable;

import me.xjqsh.lesraisinsadd.common.data.grenades.ThrowableMeta;
import me.xjqsh.lesraisinsadd.item.grenades.ThrowableItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ThrowableItemEntity<T extends ThrowableMeta>
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private IParticleData particleData;
    public float prevRotation;
    public float rotation;
    protected int maxLife;
    private ItemStack item = ItemStack.field_190927_a;
    private ThrowableItem<T> metaHolder;

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, World world, LivingEntity player, ThrowableItem<T> meta) {
        super(entityType, player, world);
        this.metaHolder = meta;
        this.maxLife = ((ThrowableMeta)this.getMeta()).getMaxLife();
    }

    public T getMeta() {
        return (T)this.metaHolder.getMeta();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    protected float func_70185_h() {
        return ((ThrowableMeta)this.getMeta()).getGravityVelocity();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= this.maxLife) {
            this.func_70106_y();
            this.onDeath();
        }
        if (this.field_70170_p.func_201670_d()) {
            if (((ThrowableMeta)this.getMeta()).shouldRot()) {
                this.prevRotation = this.rotation;
                double speed = this.func_213322_ci().func_72433_c();
                if (speed > 0.1) {
                    this.rotation += (float)(speed * 50.0);
                }
            }
            this.renderTrailing();
        }
    }

    public void renderTrailing() {
        if (this.particleData == null) {
            ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(((ThrowableMeta)this.getMeta()).getTailParticle());
            this.particleData = type instanceof IParticleData ? (IParticleData)type : ParticleTypes.field_197601_L;
        }
        this.field_70170_p.func_195590_a(this.particleData, true, this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_(), 0.0, 0.1, 0.0);
    }

    public void onDeath() {
    }

    protected void playImpactSound(BlockRayTraceResult result) {
        BlockPos resultPos = result.func_216350_a();
        BlockState state = this.field_70170_p.func_180495_p(resultPos);
        SoundEvent sound = state.func_177230_c().getSoundType(state, (IWorldReader)this.field_70170_p, resultPos, (Entity)this).func_185844_d();
        this.field_70170_p.func_184148_a(null, result.func_216347_e().field_72450_a, result.func_216347_e().field_72448_b, result.func_216347_e().field_72449_c, sound, SoundCategory.AMBIENT, 1.0f, 1.0f);
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            if (((ThrowableMeta)this.getMeta()).shouldBounce()) {
                Direction direction = blockResult.func_216354_b();
                double bf = ((ThrowableMeta)this.getMeta()).getBounceFactor();
                switch (direction.func_176740_k()) {
                    case X: {
                        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.7 * bf, bf, bf));
                        break;
                    }
                    case Y: {
                        if (((ThrowableMeta)this.getMeta()).isBrokeOnGround()) {
                            this.func_70106_y();
                            this.onDeath();
                            return;
                        }
                        this.func_213317_d(this.func_213322_ci().func_216372_d(bf, -0.5 * bf, bf));
                        if (!(this.func_213322_ci().func_82617_b() < (double)((ThrowableMeta)this.getMeta()).getGravityVelocity())) break;
                        this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                        break;
                    }
                    case Z: {
                        this.func_213317_d(this.func_213322_ci().func_216372_d(bf, bf, -0.7 * bf));
                    }
                }
                double speed = this.func_213322_ci().func_72433_c();
                if (speed > 0.1) {
                    this.playImpactSound(blockResult);
                }
            } else {
                this.func_70106_y();
                this.onDeath();
            }
        }
    }

    public boolean func_189652_ae() {
        return false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeItemStack(this.item, true);
        buffer.writeInt(this.maxLife);
        buffer.writeRegistryId(this.metaHolder);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.setItem(buffer.func_150791_c());
        this.maxLife = buffer.readInt();
        this.metaHolder = (ThrowableItem)buffer.readRegistryIdSafe(Item.class);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }
}

