/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.entity.throwable;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import me.xjqsh.lesraisinsadd.common.data.grenades.AreaGrenadeMeta;
import me.xjqsh.lesraisinsadd.effect.TickEffectInstance;
import me.xjqsh.lesraisinsadd.entity.throwable.ThrowableItemEntity;
import me.xjqsh.lesraisinsadd.init.ModEntities;
import me.xjqsh.lesraisinsadd.item.grenades.ThrowableItem;
import me.xjqsh.lesraisinsadd.util.EntityUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class AreaGrenadeEntity
extends ThrowableItemEntity<AreaGrenadeMeta> {
    private Set<BlockPos> affect = new HashSet<BlockPos>();
    private Set<BlockPos> set = new HashSet<BlockPos>();
    private Queue<AffectArea> queue = new ArrayDeque<AffectArea>();

    public AreaGrenadeEntity(World world, LivingEntity player, int useTick, ThrowableItem<AreaGrenadeMeta> effectGrenadeMeta) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.AREA_GRENADE.get()), world, player, effectGrenadeMeta);
    }

    public AreaGrenadeEntity(EntityType<? extends ThrowableItemEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    @Override
    public void func_70071_h_() {
        AffectArea affectArea;
        super.func_70071_h_();
        if (this.field_70173_aa < 80) {
            return;
        }
        float radius = (float)Math.min(this.field_70173_aa - 80, 60) / 60.0f * 8.0f;
        if (this.queue.isEmpty()) {
            this.affect.clear();
            this.affect.addAll(this.set);
            this.set.clear();
            BlockPos pos = new BlockPos(this.func_174824_e(1.0f));
            BlockState blockState = this.field_70170_p.func_180495_p(pos);
            if (!blockState.func_200132_m() && !(blockState.func_177230_c() instanceof FlowingFluidBlock)) {
                this.add(new BlockPos(this.func_174824_e(1.0f)), 12.0f);
            }
        }
        for (int i = 0; i < 64 && (affectArea = this.queue.peek()) != null; ++i) {
            BlockPos pos = affectArea.pos;
            if (this.field_70170_p.func_201670_d()) {
                this.releaseParticle(pos);
            }
            if (affectArea.strength > 0.0f) {
                for (Direction d : Direction.values()) {
                    BlockPos next = pos.func_177972_a(d);
                    BlockState bs = this.field_70170_p.func_180495_p(next);
                    if (bs.func_200132_m() || bs.func_177230_c() instanceof FlowingFluidBlock || !(next.func_218138_a((IPosition)this.func_174824_e(1.0f), false) < (double)(radius * radius))) continue;
                    this.add(next, affectArea.strength - (d.equals((Object)Direction.UP) ? 1.5f : 0.8f));
                }
            }
            this.queue.poll();
        }
        if (this.field_70170_p.func_201670_d() || this.field_70173_aa % 10 != 0) {
            return;
        }
        for (LivingEntity livingEntity : EntityUtil.getEntitiesInRadius(this.field_70170_p, ((AreaGrenadeMeta)this.getMeta()).isOnlyAffectPlayer() ? PlayerEntity.class : LivingEntity.class, this.func_174824_e(1.0f), radius)) {
            if (!this.isInArea((Entity)livingEntity)) continue;
            this.affectEntity(livingEntity);
        }
    }

    private void releaseParticle(BlockPos pos) {
        Particle particle = Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ParticleTypes.field_197613_f, (double)pos.func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * 0.2, (double)pos.func_177956_o() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 0.2, (double)pos.func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * 0.2, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, (this.field_70146_Z.nextDouble() - 0.5) * 0.1);
        if (particle != null) {
            particle.func_187114_a(60);
            particle.func_70541_f(0.5f);
            int[] color = ((AreaGrenadeMeta)this.getMeta()).getColor();
            particle.func_70538_b((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f);
        }
    }

    private void add(BlockPos pos, float i) {
        if (!this.set.contains(pos)) {
            this.queue.add(new AffectArea(pos, i));
            this.set.add(pos);
        }
    }

    public boolean isInArea(Entity entity) {
        BlockPos pos = new BlockPos(entity.func_174824_e(1.0f));
        return this.affect.contains(pos);
    }

    public void affectEntity(LivingEntity entity) {
        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(((AreaGrenadeMeta)this.getMeta()).getEffect());
        if (effect == null) {
            return;
        }
        EffectInstance instance = entity.func_70660_b(effect);
        if (instance == null || instance.func_76459_b() <= 61) {
            if (((AreaGrenadeMeta)this.getMeta()).isSpecialEffectInstance()) {
                entity.func_195064_c((EffectInstance)new TickEffectInstance(effect, ((AreaGrenadeMeta)this.getMeta()).getEffectDuration(), ((AreaGrenadeMeta)this.getMeta()).getEffectAmplifier()));
            } else {
                entity.func_195064_c(new EffectInstance(effect, ((AreaGrenadeMeta)this.getMeta()).getEffectDuration(), ((AreaGrenadeMeta)this.getMeta()).getEffectAmplifier()));
            }
        }
    }

    public static class AffectArea {
        float strength;
        BlockPos pos;

        public AffectArea(BlockPos pos, float strength) {
            this.strength = strength;
            this.pos = pos;
        }
    }
}

