/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractProjectileEntity
extends Entity {
    private UUID ownerUUID;
    private int ownerNetworkId;
    private boolean leftOwner;

    AbstractProjectileEntity(EntityType<? extends AbstractProjectileEntity> p_i231584_1_, World p_i231584_2_) {
        super(p_i231584_1_, p_i231584_2_);
    }

    public void setOwner(@Nullable Entity p_212361_1_) {
        if (p_212361_1_ != null) {
            this.ownerUUID = p_212361_1_.func_110124_au();
            this.ownerNetworkId = p_212361_1_.func_145782_y();
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.ownerUUID != null && this.field_70170_p instanceof ServerWorld) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUUID);
        }
        return this.ownerNetworkId != 0 ? this.field_70170_p.func_73045_a(this.ownerNetworkId) : null;
    }

    protected void func_213281_b(CompoundNBT p_213281_1_) {
        if (this.ownerUUID != null) {
            p_213281_1_.func_186854_a("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            p_213281_1_.func_74757_a("LeftOwner", true);
        }
    }

    protected void func_70037_a(CompoundNBT p_70037_1_) {
        if (p_70037_1_.func_186855_b("Owner")) {
            this.ownerUUID = p_70037_1_.func_186857_a("Owner");
        }
        this.leftOwner = p_70037_1_.func_74767_n("LeftOwner");
    }

    public void func_70071_h_() {
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.func_70071_h_();
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_234613_0_ -> !p_234613_0_.func_175149_v() && p_234613_0_.func_70067_L())) {
                if (entity1.func_184208_bv() != entity.func_184208_bv()) continue;
                return false;
            }
        }
        return true;
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vector3d vector3d = new Vector3d(p_70186_1_, p_70186_3_, p_70186_5_).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_).func_186678_a((double)p_70186_7_);
        this.func_213317_d(vector3d);
        float f = MathHelper.func_76133_a((double)AbstractProjectileEntity.func_213296_b((Vector3d)vector3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void shootFromRotation(Entity p_234612_1_, float p_234612_2_, float p_234612_3_, float p_234612_4_, float p_234612_5_, float p_234612_6_) {
        float f = -MathHelper.func_76126_a((float)(p_234612_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_234612_2_ * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((p_234612_2_ + p_234612_4_) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(p_234612_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_234612_2_ * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, p_234612_5_, p_234612_6_);
        Vector3d vector3d = p_234612_1_.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vector3d.field_72450_a, p_234612_1_.func_233570_aj_() ? 0.0 : vector3d.field_72448_b, vector3d.field_72449_c));
    }

    protected void onHitEntity(EntityRayTraceResult p_213868_1_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.func_213293_j(p_70016_1_, p_70016_3_, p_70016_5_);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(p_70016_1_ * p_70016_1_ + p_70016_5_ * p_70016_5_));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)p_70016_3_, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)p_70016_1_, (double)p_70016_5_) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        if (!p_230298_1_.func_175149_v() && p_230298_1_.func_70089_S() && p_230298_1_.func_70067_L()) {
            Entity entity = this.getOwner();
            return entity == null || this.leftOwner || !entity.func_184223_x(p_230298_1_);
        }
        return false;
    }

    protected void updateRotation() {
        Vector3d vector3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)AbstractProjectileEntity.func_213296_b((Vector3d)vector3d));
        this.field_70125_A = AbstractProjectileEntity.lerpRotation(this.field_70127_C, (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875));
        this.field_70177_z = AbstractProjectileEntity.lerpRotation(this.field_70126_B, (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875));
    }

    protected static float lerpRotation(float p_234614_0_, float p_234614_1_) {
        while (p_234614_1_ - p_234614_0_ < -180.0f) {
            p_234614_0_ -= 360.0f;
        }
        while (p_234614_1_ - p_234614_0_ >= 180.0f) {
            p_234614_0_ += 360.0f;
        }
        return MathHelper.func_219799_g((float)0.2f, (float)p_234614_0_, (float)p_234614_1_);
    }
}

