/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.common.data.grenades;

import me.xjqsh.lesraisinsadd.common.data.IMeta;
import me.xjqsh.lesraisinsadd.common.data.grenades.ThrowableMeta;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class CloudGrenadeMeta
extends ThrowableMeta {
    private CloudMeta cloud = new CloudMeta();
    private ResourceLocation effect = new ResourceLocation("minecraft:poison");
    private int effectDuration = 100;
    private int effectAmplifier = 0;
    private boolean specialEffectInstance = false;
    private boolean onlyAffectPlayer = false;

    @Override
    public void writeBuffer(PacketBuffer buffer) {
        super.writeBuffer(buffer);
        buffer.func_192572_a(this.effect);
        buffer.writeInt(this.effectDuration);
        buffer.writeInt(this.effectAmplifier);
        buffer.writeBoolean(this.specialEffectInstance);
        buffer.writeBoolean(this.onlyAffectPlayer);
        this.cloud.writeBuffer(buffer);
    }

    @Override
    public void readBuffer(PacketBuffer buffer) {
        super.readBuffer(buffer);
        this.effect = buffer.func_192575_l();
        this.effectDuration = buffer.readInt();
        this.effectAmplifier = buffer.readInt();
        this.specialEffectInstance = buffer.readBoolean();
        this.onlyAffectPlayer = buffer.readBoolean();
        this.cloud.readBuffer(buffer);
    }

    public ResourceLocation getEffect() {
        return this.effect;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public boolean isSpecialEffectInstance() {
        return this.specialEffectInstance;
    }

    public boolean isOnlyAffectPlayer() {
        return this.onlyAffectPlayer;
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public CloudMeta getCloud() {
        return this.cloud;
    }

    public static class CloudMeta
    implements IMeta {
        private int cloudLifeTime = 600;
        private float height = 1.2f;
        private float startRadius = 2.5f;
        private float maxRadius = 8.0f;
        private float radiusPerTick = 0.05f;
        private boolean extinguishBySmoke = false;
        private ResourceLocation particle = new ResourceLocation("minecraft:flame");

        @Override
        public void writeBuffer(PacketBuffer buffer) {
            buffer.writeInt(this.cloudLifeTime);
            buffer.writeFloat(this.height);
            buffer.writeFloat(this.startRadius);
            buffer.writeFloat(this.maxRadius);
            buffer.writeFloat(this.radiusPerTick);
            buffer.writeBoolean(this.extinguishBySmoke);
            buffer.func_192572_a(this.particle);
        }

        @Override
        public void readBuffer(PacketBuffer buffer) {
            this.cloudLifeTime = buffer.readInt();
            this.height = buffer.readFloat();
            this.startRadius = buffer.readFloat();
            this.maxRadius = buffer.readFloat();
            this.radiusPerTick = buffer.readFloat();
            this.extinguishBySmoke = buffer.readBoolean();
            this.particle = buffer.func_192575_l();
        }

        public boolean isExtinguishBySmoke() {
            return this.extinguishBySmoke;
        }

        public int getCloudLifeTime() {
            return this.cloudLifeTime;
        }

        public ResourceLocation getParticle() {
            return this.particle;
        }

        public float getHeight() {
            return this.height;
        }

        public float getStartRadius() {
            return this.startRadius;
        }

        public float getMaxRadius() {
            return this.maxRadius;
        }

        public float getRadiusPerTick() {
            return this.radiusPerTick;
        }
    }
}

