/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.common.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import me.xjqsh.lesraisinsadd.LesRaisinsTaCAddon;
import me.xjqsh.lesraisinsadd.common.data.IMetaHolder;
import me.xjqsh.lesraisinsadd.item.grenades.ThrowableItem;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lesraisinsadd")
public class NetworkDataManager
extends ReloadListener<Map<Item, JsonElement>> {
    private static NetworkDataManager INSTANCE;
    public static final JsonDeserializer<ResourceLocation> RESOURCE_LOCATION;
    public static final Gson GSON;
    private Map<ResourceLocation, JsonElement> metaMap = new HashMap<ResourceLocation, JsonElement>();

    public static NetworkDataManager getInstance() {
        return INSTANCE;
    }

    public Map<ResourceLocation, JsonElement> getMetaMap() {
        return this.metaMap;
    }

    protected Map<Item, JsonElement> prepare(IResourceManager resourceManager, IProfiler profiler) {
        LesRaisinsTaCAddon.LOGGER.info("Start loading custom data...");
        HashMap map = Maps.newHashMap();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IMetaHolder).forEach(item -> {
            ResourceLocation id = item.getRegistryName();
            ThrowableItem metaHolder = (ThrowableItem)item;
            if (id != null) {
                ResourceLocation rl = new ResourceLocation(String.format("%s:%s/%s.json", id.func_110624_b(), metaHolder.getPath(), id.func_110623_a()));
                try (IResource iresource = resourceManager.func_199002_a(rl);
                     InputStream inputstream = iresource.func_199027_b();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    JsonElement jsonelement = (JsonElement)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                    if (jsonelement != null) {
                        map.put(item, jsonelement);
                    } else {
                        LesRaisinsTaCAddon.LOGGER.error("Couldn't load data file {} as it's null or empty", (Object)rl);
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException e) {
                    LesRaisinsTaCAddon.LOGGER.error("Couldn't parse data file {}: {}", (Object)rl, (Object)e);
                }
            }
        });
        return map;
    }

    protected void apply(Map<Item, JsonElement> map, IResourceManager resourceManager, IProfiler profiler) {
        this.metaMap.clear();
        map.forEach((item, jsonElement) -> {
            if (item instanceof IMetaHolder) {
                ((IMetaHolder)item).loadFromJson(GSON, (JsonElement)jsonElement);
                this.metaMap.put(item.getRegistryName(), (JsonElement)jsonElement);
            }
        });
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkDataManager manager = new NetworkDataManager();
        event.addListener((IFutureReloadListener)manager);
        INSTANCE = manager;
    }

    static {
        RESOURCE_LOCATION = (json, typeOfT, context) -> new ResourceLocation(json.getAsString());
        GSON = (Gson)Util.func_199748_a(() -> {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(ResourceLocation.class, RESOURCE_LOCATION);
            return builder.create();
        });
    }
}

