/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.common;

import com.tac.guns.Config;
import com.tac.guns.common.Gun;
import com.tac.guns.entity.DamageSourceProjectile;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.util.GunModifierHelper;
import me.xjqsh.lesraisinsadd.common.data.NetworkDataManager;
import me.xjqsh.lesraisinsadd.entity.X26HookEntity;
import me.xjqsh.lesraisinsadd.init.ModItems;
import me.xjqsh.lesraisinsadd.init.ModTags;
import me.xjqsh.lesraisinsadd.item.interfaces.IDefeatAction;
import me.xjqsh.lesraisinsadd.item.interfaces.IFireAction;
import me.xjqsh.lesraisinsadd.item.interfaces.IReloadAction;
import me.xjqsh.lesraisinsadd.item.shield.RiotShieldItem;
import me.xjqsh.lesraisinsadd.network.message.SCustomMeta;
import me.xjqsh.lesraisinsadd.network.message.SDefeatSpEffect;
import me.xjqsh.lesraisinsadd.network.message.SPlayerReload;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ServerPlayHandler {
    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent e) {
        if (e.getPlayer() == null) {
            me.xjqsh.lesraisinsadd.network.PacketHandler.getPlayChannel().send(PacketDistributor.ALL.noArg(), (Object)new SCustomMeta(NetworkDataManager.getInstance().getMetaMap()));
            return;
        }
        me.xjqsh.lesraisinsadd.network.PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)e).getPlayer()), (Object)new SCustomMeta(NetworkDataManager.getInstance().getMetaMap()));
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        PlayerEntity entity;
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntity() instanceof PlayerEntity && (entity = (PlayerEntity)event.getEntity()).func_184614_ca().func_77973_b() instanceof RiotShieldItem) {
            ItemStack stack = entity.func_184614_ca();
            int i = 1 + MathHelper.func_76141_d((float)event.getAmount());
            stack.func_222118_a(i, (LivingEntity)entity, item -> {
                item.func_213334_d(Hand.MAIN_HAND);
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)entity, (ItemStack)stack, (Hand)Hand.MAIN_HAND);
            });
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource() instanceof DamageSourceProjectile) {
            if (!event.getEntity().func_200600_R().func_220341_a(ModTags.caster)) {
                return;
            }
            DamageSourceProjectile source = (DamageSourceProjectile)event.getSource();
            ItemStack weapon = source.getWeapon();
            if (weapon.func_77973_b().equals(ModItems.ENCORE.get())) {
                event.setAmount(event.getAmount() * 2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.isCanceled() || event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        if (event.getSource() instanceof DamageSourceProjectile) {
            DamageSourceProjectile source = (DamageSourceProjectile)event.getSource();
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            Entity suffer = event.getEntity();
            if (player.func_184614_ca().func_77973_b() instanceof IDefeatAction) {
                ((IDefeatAction)player.func_184614_ca().func_77973_b()).onGunDefeat(event, player.func_184614_ca(), source);
            }
            if (!player.func_184592_cb().func_77973_b().equals(ModItems.SEAL.get())) {
                return;
            }
            Vector3d v = suffer.func_174824_e(1.0f);
            me.xjqsh.lesraisinsadd.network.PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(v.field_72450_a, v.field_72448_b, v.field_72449_c, 64.0, suffer.field_70170_p.func_234923_W_())), (Object)new SDefeatSpEffect(v));
        }
    }

    @SubscribeEvent
    public static void onGunReload(GunReloadEvent.Post event) {
        if (event.isCanceled() || event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        ItemStack weapon = event.getStack();
        if (event.getStack().func_77973_b() instanceof IReloadAction) {
            ((IReloadAction)event.getStack().func_77973_b()).onGunReload(event, weapon);
        }
        if (((GunItem)ModItems.BAM4.get()).equals(weapon.func_77973_b()) || ((GunItem)ModItems.MP18.get()).equals(weapon.func_77973_b())) {
            me.xjqsh.lesraisinsadd.network.PacketHandler.getPlayChannel().send(PacketDistributor.DIMENSION.with(() -> event.getPlayer().field_70170_p.func_234923_W_()), (Object)new SPlayerReload(event.getPlayer().func_110124_au()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onX26GunFire(GunFireEvent.Pre event) {
        if (event.isCanceled() || event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        ItemStack weapon = event.getStack();
        if (((GunItem)ModItems.X26.get()).getItem().equals(weapon.func_77973_b())) {
            CompoundNBT tag;
            ResourceLocation fireSound;
            World world = event.getPlayer().field_70170_p;
            GunItem item = (GunItem)weapon.func_77973_b();
            Gun modifiedGun = item.getModifiedGun(weapon);
            PlayerEntity player = event.getPlayer();
            event.setCanceled(true);
            X26HookEntity hook = new X26HookEntity(event.getPlayer());
            hook.shootFromRotation((Entity)event.getPlayer(), event.getPlayer().field_70125_A, event.getPlayer().field_70177_z, 0.0f, 5.0f, 2.5f);
            hook.setDamage(modifiedGun.getProjectile().getDamage());
            event.getPlayer().field_70170_p.func_217376_c((Entity)hook);
            boolean silenced = GunModifierHelper.isSilencedFire((ItemStack)weapon);
            ResourceLocation resourceLocation = fireSound = silenced ? modifiedGun.getSounds().getSilencedFire() : modifiedGun.getSounds().getFire();
            if (fireSound != null) {
                double posX = player.func_226277_ct_();
                double posY = player.func_226278_cu_() + (double)player.func_70047_e();
                double posZ = player.func_226281_cx_();
                float volume = GunModifierHelper.getFireSoundVolume((ItemStack)weapon);
                float pitch = 0.9f + world.field_73012_v.nextFloat() * 0.125f;
                double radius = GunModifierHelper.getModifiedFireSoundRadius((ItemStack)weapon, (double)((Double)Config.SERVER.gunShotMaxDistance.get()));
                boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
                MessageGunSound messageSound = new MessageGunSound(fireSound, SoundCategory.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.func_145782_y(), muzzle, false);
                PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(posX, posY, posZ, radius, player.field_70170_p.func_234923_W_());
                PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)messageSound);
            }
            if (!player.func_184812_l_() && !(tag = weapon.func_196082_o()).func_74767_n("IgnoreAmmo")) {
                tag.func_74768_a("AmmoCount", Math.max(0, tag.func_74762_e("AmmoCount") - 1));
            }
            MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(event.getPlayer(), weapon));
        }
    }

    @SubscribeEvent
    public static void onGunFire(GunFireEvent.Post event) {
        if (event.isCanceled() || event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        ItemStack weapon = event.getStack();
        if (event.getStack().func_77973_b() instanceof IFireAction) {
            ((IFireAction)event.getStack().func_77973_b()).onGunFire(event, weapon);
        }
    }
}

