/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import me.xjqsh.lesraisinsadd.client.listener.ModelCaches;
import me.xjqsh.lesraisinsadd.entity.BeamEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class BeamRender
extends EntityRenderer<BeamEntity> {
    private static final RenderType LRBEAM = RenderType.func_228633_a_((String)"lrbeam", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)131072, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(false)).func_228719_a_(new RenderState.LightmapState(true)).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, false)).func_228713_a_(new RenderState.AlphaState(0.5f)).func_228728_a_(true));

    public BeamRender(EntityRendererManager manager) {
        super(manager);
    }

    public void render(BeamEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.125, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(entity.getYr()));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entity.getXr()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(entity.field_70173_aa * entity.getRotateSpeed()) / 2.0f % 20.0f * 18.0f));
        matrixStack.func_227862_a_(entity.calcScale(), entity.calcScale(), 1.0f);
        matrixStack.func_227861_a_(0.0, 0.0, 10.0);
        matrixStack.func_227862_a_(1.0f, 1.0f, 20.0f);
        IBakedModel model = ModelCaches.BEAM.getModel();
        if (model != null) {
            Direction[] var9;
            IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)LRBEAM, (boolean)true, (boolean)false);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            Random random = new Random();
            for (Direction direction : var9 = Direction.values()) {
                random.setSeed(42L);
                BeamRender.renderQuads(matrixStack, builder, model.func_200117_a(null, direction, random), 0xF000F0, OverlayTexture.field_229196_a_, entity.getColor());
            }
            random.setSeed(42L);
            BeamRender.renderQuads(matrixStack, builder, model.func_200117_a(null, null, random), 0xF000F0, OverlayTexture.field_229196_a_, entity.getColor());
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private static void renderQuads(MatrixStack matrixStack, IVertexBuilder buffer, List<BakedQuad> quads, int light, int overlay, int color) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        for (BakedQuad quad : quads) {
            float alpha = 1.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            float x = Math.max(red, Math.max(green, blue));
            buffer.addVertexData(entry, quad, red / x, green / x, blue / x, alpha, light, overlay, false);
        }
    }

    public ResourceLocation getTextureLocation(BeamEntity p_110775_1_) {
        return new ResourceLocation("lesraisinsadd:textures/entity/beam.png");
    }

    public boolean shouldRender(BeamEntity p_225626_1_, ClippingHelper p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        return true;
    }
}

