/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.client.listener;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

@Mod.EventBusSubscriber(modid="lesraisinsadd", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public enum ModelCaches {
    BEAM("entity/beam"),
    AF6("special/af6_scope"),
    AF6_LIGHT("special/af6_scope_light"),
    X26("entity/x26_hook");

    private final ResourceLocation rl;
    private IBakedModel cachedModel;

    private ModelCaches(String rl) {
        this.rl = new ResourceLocation("lesraisinsadd", rl);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel getModel() {
        if (this.cachedModel == null) {
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(this.rl);
            if (model == Minecraft.func_71410_x().func_209506_al().func_174951_a()) {
                return model;
            }
            this.cachedModel = model;
        }
        return this.cachedModel;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void register(ModelRegistryEvent event) {
        for (ModelCaches c : ModelCaches.values()) {
            ModelLoader.addSpecialModel((ResourceLocation)c.rl);
        }
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        ((SimpleReloadableResourceManager)manager).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
            for (ModelCaches c : ModelCaches.values()) {
                c.cachedModel = null;
            }
        }));
    }
}

