/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.client.animation;

import com.tac.guns.GunMod;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.client.render.animation.module.BoltActionAnimationController;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import java.io.IOException;
import me.xjqsh.lesraisinsadd.init.ModItems;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NTW20AnimationController
extends BoltActionAnimationController {
    public static int INDEX_BODY = 5;
    public static int INDEX_LEFT_HAND = 7;
    public static int INDEX_RIGHT_HAND = 0;
    public static int INDEX_BOLT = 2;
    public static int INDEX_MAG = 4;
    public static int INDEX_BULLET = 3;
    public static final AnimationMeta RELOAD_EMPTY = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/ntw20_reload_empty.gltf"));
    public static final AnimationMeta RELOAD_NORM = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/ntw20_reload_norm.gltf"));
    public static final AnimationMeta PULL_BOLT = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/ntw20_bolt.gltf"));
    public static final AnimationMeta INSPECT = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/ntw20_inspect.gltf"));
    public static final AnimationMeta DRAW = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/ntw20_draw.gltf"));
    public static final AnimationMeta STATIC = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/ntw20_static.gltf"));
    private static NTW20AnimationController instance;

    private NTW20AnimationController() {
        try {
            Animations.load((AnimationMeta)RELOAD_EMPTY);
            Animations.load((AnimationMeta)RELOAD_NORM);
            Animations.load((AnimationMeta)INSPECT);
            Animations.load((AnimationMeta)DRAW);
            Animations.load((AnimationMeta)PULL_BOLT);
            Animations.load((AnimationMeta)STATIC);
        }
        catch (IOException e) {
            GunMod.LOGGER.fatal((Object)e.getStackTrace());
        }
        this.enableStaticState();
        GunAnimationController.setAnimationControllerMap((ResourceLocation)ModItems.NTW20.getId(), (GunAnimationController)this);
    }

    public static NTW20AnimationController getInstance() {
        if (instance == null) {
            instance = new NTW20AnimationController();
        }
        return instance;
    }

    public AnimationMeta getAnimationFromLabel(GunAnimationController.AnimationLabel label) {
        switch (label) {
            case INSPECT_EMPTY: 
            case INSPECT: {
                return INSPECT;
            }
            case DRAW: {
                return DRAW;
            }
            case STATIC: {
                return STATIC;
            }
            case RELOAD_NORMAL: {
                return RELOAD_NORM;
            }
            case RELOAD_EMPTY: {
                return RELOAD_EMPTY;
            }
            case PULL_BOLT: {
                return PULL_BOLT;
            }
        }
        return null;
    }

    public AnimationSoundMeta getSoundFromLabel(GunAnimationController.AnimationLabel label) {
        return super.getSoundFromLabel((Item)ModItems.NTW20.get(), label);
    }

    protected int getAttachmentsNodeIndex() {
        return INDEX_BODY;
    }

    protected int getRightHandNodeIndex() {
        return INDEX_RIGHT_HAND;
    }

    protected int getLeftHandNodeIndex() {
        return INDEX_LEFT_HAND;
    }
}

