/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.client.animation;

import com.tac.guns.GunMod;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import java.io.IOException;
import me.xjqsh.lesraisinsadd.init.ModItems;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MG42AnimationController
extends GunAnimationController {
    public static int INDEX_BODY = 6;
    public static int INDEX_LEFT_HAND = 8;
    public static int INDEX_RIGHT_HAND = 0;
    public static int INDEX_BULLET_CHAIN = 2;
    public static int INDEX_MAG = 3;
    public static int INDEX_BOLT = 4;
    public static int INDEX_CAP = 5;
    public static final AnimationMeta RELOAD = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/mg42_reload.gltf"));
    public static final AnimationMeta INSPECT = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/mg42_inspect.gltf"));
    public static final AnimationMeta DRAW = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/mg42_draw.gltf"));
    public static final AnimationMeta STATIC = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/mg42_static.gltf"));
    private static MG42AnimationController instance;

    private MG42AnimationController() {
        try {
            Animations.load((AnimationMeta)RELOAD);
            Animations.load((AnimationMeta)INSPECT);
            Animations.load((AnimationMeta)DRAW);
            Animations.load((AnimationMeta)STATIC);
        }
        catch (IOException e) {
            GunMod.LOGGER.fatal((Object)e.getStackTrace());
        }
        this.enableStaticState();
        GunAnimationController.setAnimationControllerMap((ResourceLocation)ModItems.MG42.getId(), (GunAnimationController)this);
    }

    public static MG42AnimationController getInstance() {
        if (instance == null) {
            instance = new MG42AnimationController();
        }
        return instance;
    }

    public AnimationMeta getAnimationFromLabel(GunAnimationController.AnimationLabel label) {
        switch (label) {
            case INSPECT_EMPTY: 
            case INSPECT: {
                return INSPECT;
            }
            case DRAW: {
                return DRAW;
            }
            case STATIC: {
                return STATIC;
            }
            case RELOAD_NORMAL: 
            case RELOAD_EMPTY: {
                return RELOAD;
            }
        }
        return null;
    }

    public AnimationSoundMeta getSoundFromLabel(GunAnimationController.AnimationLabel label) {
        return super.getSoundFromLabel((Item)ModItems.MG42.get(), label);
    }

    protected int getAttachmentsNodeIndex() {
        return INDEX_BODY;
    }

    protected int getRightHandNodeIndex() {
        return INDEX_RIGHT_HAND;
    }

    protected int getLeftHandNodeIndex() {
        return INDEX_LEFT_HAND;
    }
}

