/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.client.animation;

import com.tac.guns.GunMod;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import java.io.IOException;
import me.xjqsh.lesraisinsadd.client.animation.IFireController;
import me.xjqsh.lesraisinsadd.init.ModItems;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FLINTLOCKAnimationController
extends GunAnimationController
implements IFireController {
    public static int INDEX_BODY = 4;
    public static int INDEX_LEFT_HAND = 9;
    public static int INDEX_RIGHT_HAND = 0;
    public static int INDEX_STICK = 5;
    public static int INDEX_BULLET = 6;
    public static int INDEX_BOTTLE = 7;
    public static int INDEX_PLATE = 2;
    public static int INDEX_HAMMER = 3;
    public static final AnimationMeta FIRE = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/flintlock_fire.gltf"));
    public static final AnimationMeta RELOAD = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/flintlock_reload.gltf"));
    public static final AnimationMeta INSPECT = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/flintlock_inspect.gltf"));
    public static final AnimationMeta DRAW = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/flintlock_draw.gltf"));
    public static final AnimationMeta STATIC = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/flintlock_static.gltf"));
    private static FLINTLOCKAnimationController instance;

    private FLINTLOCKAnimationController() {
        try {
            Animations.load((AnimationMeta)RELOAD);
            Animations.load((AnimationMeta)INSPECT);
            Animations.load((AnimationMeta)DRAW);
            Animations.load((AnimationMeta)STATIC);
            Animations.load((AnimationMeta)FIRE);
        }
        catch (IOException e) {
            GunMod.LOGGER.fatal((Object)e.getStackTrace());
        }
        this.enableStaticState();
        GunAnimationController.setAnimationControllerMap((ResourceLocation)ModItems.FLINTLOCK.getId(), (GunAnimationController)this);
    }

    public static FLINTLOCKAnimationController getInstance() {
        if (instance == null) {
            instance = new FLINTLOCKAnimationController();
        }
        return instance;
    }

    public AnimationMeta getAnimationFromLabel(GunAnimationController.AnimationLabel label) {
        switch (label) {
            case INSPECT_EMPTY: 
            case INSPECT: {
                return INSPECT;
            }
            case DRAW: {
                return DRAW;
            }
            case STATIC: {
                return STATIC;
            }
            case RELOAD_NORMAL: 
            case RELOAD_EMPTY: {
                return RELOAD;
            }
        }
        return null;
    }

    public AnimationSoundMeta getSoundFromLabel(GunAnimationController.AnimationLabel label) {
        return super.getSoundFromLabel((Item)ModItems.FLINTLOCK.get(), label);
    }

    protected int getAttachmentsNodeIndex() {
        return INDEX_BODY;
    }

    protected int getRightHandNodeIndex() {
        return INDEX_RIGHT_HAND;
    }

    protected int getLeftHandNodeIndex() {
        return INDEX_LEFT_HAND;
    }

    @Override
    public void runFireAnimation() {
        this.runAnimation(FIRE, null, null);
    }

    @Override
    public boolean isFireAnimationRunning() {
        return Animations.isAnimationRunning((AnimationMeta)FIRE);
    }
}

