/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsadd.client.animation;

import com.tac.guns.GunMod;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import java.io.IOException;
import me.xjqsh.lesraisinsadd.client.animation.IFireController;
import me.xjqsh.lesraisinsadd.init.ModItems;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ANGLEAnimationController
extends GunAnimationController
implements IFireController {
    public static int INDEX_BODY = 7;
    public static int INDEX_LEFT_HAND = 9;
    public static int INDEX_RIGHT_HAND = 0;
    public static int INDEX_BULLETS = 3;
    public static int INDEX_LOADER = 5;
    public static int INDEX_MAG = 4;
    public static int INDEX_HAMMER = 6;
    public static final AnimationMeta RELOAD_NORM = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/angel_reload.gltf"));
    public static final AnimationMeta INSPECT = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/angel_inspect.gltf"));
    public static final AnimationMeta DRAW = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/angel_draw.gltf"));
    public static final AnimationMeta STATIC = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/angel_static.gltf"));
    public static final AnimationMeta FIRE = new AnimationMeta(new ResourceLocation("lesraisinsadd", "animations/angel_fire.gltf"));
    private static ANGLEAnimationController instance;

    private ANGLEAnimationController() {
        try {
            Animations.load((AnimationMeta)RELOAD_NORM);
            Animations.load((AnimationMeta)INSPECT);
            Animations.load((AnimationMeta)DRAW);
            Animations.load((AnimationMeta)STATIC);
            Animations.load((AnimationMeta)FIRE);
        }
        catch (IOException e) {
            GunMod.LOGGER.fatal((Object)e.getStackTrace());
        }
        this.enableStaticState();
        GunAnimationController.setAnimationControllerMap((ResourceLocation)ModItems.ANGEL.getId(), (GunAnimationController)this);
    }

    public static ANGLEAnimationController getInstance() {
        if (instance == null) {
            instance = new ANGLEAnimationController();
        }
        return instance;
    }

    public AnimationMeta getAnimationFromLabel(GunAnimationController.AnimationLabel label) {
        switch (label) {
            case INSPECT_EMPTY: 
            case INSPECT: {
                return INSPECT;
            }
            case RELOAD_EMPTY: 
            case RELOAD_NORMAL: {
                return RELOAD_NORM;
            }
            case DRAW: {
                return DRAW;
            }
            case STATIC: {
                return STATIC;
            }
        }
        return null;
    }

    public AnimationSoundMeta getSoundFromLabel(GunAnimationController.AnimationLabel label) {
        return super.getSoundFromLabel((Item)ModItems.ANGEL.get(), label);
    }

    protected int getAttachmentsNodeIndex() {
        return INDEX_BODY;
    }

    protected int getRightHandNodeIndex() {
        return INDEX_RIGHT_HAND;
    }

    protected int getLeftHandNodeIndex() {
        return INDEX_LEFT_HAND;
    }

    @Override
    public void runFireAnimation() {
        this.runAnimation(FIRE, null, null);
    }

    @Override
    public boolean isFireAnimationRunning() {
        return Animations.isAnimationRunning((AnimationMeta)FIRE);
    }
}

