/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.render;

import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class TooltipDecor {
    private static final ResourceLocation TEXTURE_TOOLTIP_BORDERS = new ResourceLocation("legendarytooltips", "textures/gui/tooltip_borders.png");
    private static int currentTooltipBorderStart = 0;
    private static int currentTooltipBorderEnd = 0;
    private static int shineTimer = 0;
    private static List<ITextProperties> cachedPreWrapLines = new ArrayList<ITextProperties>();

    public static void setCurrentTooltipBorderStart(int color) {
        currentTooltipBorderStart = color;
    }

    public static void setCurrentTooltipBorderEnd(int color) {
        currentTooltipBorderEnd = color;
    }

    public static void setCachedLines(List<? extends ITextProperties> lines) {
        cachedPreWrapLines.clear();
        cachedPreWrapLines.addAll(lines);
    }

    public static void updateTimer() {
        if (shineTimer > 0) {
            --shineTimer;
        }
    }

    public static void resetTimer() {
        shineTimer = 50;
    }

    public static void drawShadow(MatrixStack matrixStack, int x, int y, int width, int height) {
        int shadowColor = 0x44000000;
        matrixStack.func_227860_a_();
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)390, (int)(x - 1), (int)(y + height + 4), (int)(x + width + 4), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)390, (int)(x + width + 4), (int)(y - 1), (int)(x + width + 5), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)390, (int)(x + width + 3), (int)(y + height + 3), (int)(x + width + 4), (int)(y + height + 4), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)390, (int)x, (int)(y + height + 5), (int)(x + width + 5), (int)(y + height + 6), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)390, (int)(x + width + 5), (int)y, (int)(x + width + 6), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        matrixStack.func_227865_b_();
    }

    public static void drawSeparator(MatrixStack matrixStack, int x, int y, int width, int color) {
        matrixStack.func_227860_a_();
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        GuiHelper.drawGradientRectHorizontal((Matrix4f)mat, (int)402, (int)x, (int)y, (int)(x + width / 2), (int)(y + 1), (int)(color & 0xFFFFFF), (int)color);
        GuiHelper.drawGradientRectHorizontal((Matrix4f)mat, (int)402, (int)(x + width / 2), (int)y, (int)(x + width), (int)(y + 1), (int)color, (int)(color & 0xFFFFFF));
        matrixStack.func_227865_b_();
    }

    public static void drawBorder(MatrixStack matrixStack, int x, int y, int width, int height, ItemStack item, List<? extends ITextProperties> lines, FontRenderer font, int frameLevel, boolean comparison) {
        if (comparison) {
            matrixStack.func_227860_a_();
            Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(x + width + 2), (int)(y - 3 + 1), (int)(x + width + 3), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y - 3 + 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderStart);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(x - 3), (int)(y + height + 2), (int)(x + width + 3), (int)(y + height + 3), (int)currentTooltipBorderEnd, (int)currentTooltipBorderEnd);
            matrixStack.func_227865_b_();
            TooltipDecor.drawSeparator(matrixStack, x - 3 + 1, y - 3 + 1 + 10, width, currentTooltipBorderStart);
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.nameSeparator.get()).booleanValue() && !cachedPreWrapLines.isEmpty()) {
            ITextProperties textLine = cachedPreWrapLines.get(0);
            List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, width, Style.field_240709_b_);
            int titleLineCount = wrappedLine.size();
            if (cachedPreWrapLines.size() > titleLineCount) {
                int offset = 0;
                if (comparison) {
                    offset = 11;
                }
                TooltipDecor.drawSeparator(matrixStack, x - 3 + 1, y - 3 + 1 + titleLineCount * 10 + 1 + offset, width, currentTooltipBorderStart);
            }
        }
        if (frameLevel >= 16 || frameLevel < 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TEXTURE_TOOLTIP_BORDERS);
        int textureWidth = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4096);
        int textureHeight = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4097);
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.shineEffect.get()).booleanValue()) {
            int alpha;
            float interval;
            matrixStack.func_227860_a_();
            Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
            if (shineTimer >= 10 && shineTimer <= 40) {
                interval = MathHelper.func_76131_a((float)((float)(shineTimer - 10) / 20.0f), (float)0.0f, (float)1.0f);
                alpha = (int)(153.0f * interval) << 24;
                int horizontalMin = x - 3;
                int horizontalMax = x + width + 3;
                int horizontalInterval = (int)MathHelper.func_219799_g((float)(interval * interval), (float)horizontalMax, (float)horizontalMin);
                GuiHelper.drawGradientRectHorizontal((Matrix4f)mat, (int)402, (int)Math.max(horizontalInterval - 36, horizontalMin), (int)(y - 3), (int)Math.min(horizontalInterval, horizontalMax), (int)(y - 3 + 1), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiHelper.drawGradientRectHorizontal((Matrix4f)mat, (int)402, (int)Math.max(horizontalInterval, horizontalMin), (int)(y - 3), (int)Math.min(horizontalInterval + 36, horizontalMax), (int)(y - 3 + 1), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            if (shineTimer <= 20) {
                interval = MathHelper.func_76131_a((float)((float)shineTimer / 20.0f), (float)0.0f, (float)1.0f);
                alpha = (int)(85.0f * interval) << 24;
                int verticalMin = y - 3 + 1;
                int verticalMax = y + height + 3 - 1;
                int verticalInterval = (int)MathHelper.func_219799_g((float)(interval * interval), (float)verticalMax, (float)verticalMin);
                GuiUtils.drawGradientRect((Matrix4f)mat, (int)402, (int)(x - 3), (int)Math.max(verticalInterval - 12, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval, verticalMax), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiUtils.drawGradientRect((Matrix4f)mat, (int)402, (int)(x - 3), (int)Math.max(verticalInterval, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval + 12, verticalMax), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 410.0);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x - 6), (int)(y - 6), (float)(frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + width - 8 + 6), (int)(y - 6), (float)(56 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x - 6), (int)(y + height - 8 + 6), (float)(frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight + 8), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + width - 8 + 6), (int)(y + height - 8 + 6), (float)(56 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight + 8), (int)8, (int)8, (int)textureWidth, (int)textureHeight);
        if (width >= 48) {
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + width / 2 - 24), (int)(y - 9), (float)(8 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight), (int)48, (int)8, (int)textureWidth, (int)textureHeight);
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + width / 2 - 24), (int)(y + height - 8 + 9), (float)(8 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight + 8), (int)48, (int)8, (int)textureWidth, (int)textureHeight);
        }
        matrixStack.func_227865_b_();
    }
}

