/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.RenderTooltipExtEvent;
import com.anthonyhilyard.iceberg.util.ItemColor;
import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="legendarytooltips", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class LegendaryTooltips {
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static ItemStack lastTooltipItem = null;

    private static Pair<Integer, Integer> itemFrameColors(ItemStack item, Pair<Integer, Integer> defaults) {
        int frameLevel = LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(item);
        switch (frameLevel) {
            case -2: {
                return defaults;
            }
            case -1: {
                if (!((Boolean)LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.get()).booleanValue()) break;
                net.minecraft.util.text.Color rarityColor = ItemColor.getColorForItem((ItemStack)item, (net.minecraft.util.text.Color)net.minecraft.util.text.Color.func_240744_a_((TextFormatting)TextFormatting.WHITE));
                float[] hsbVals = new float[3];
                Color.RGBtoHSB(rarityColor.func_240742_a_() >> 16 & 0xFF, rarityColor.func_240742_a_() >> 8 & 0xFF, rarityColor.func_240742_a_() >> 0 & 0xFF, hsbVals);
                boolean addHue = false;
                if (hsbVals[0] * 360.0f < 62.0f) {
                    addHue = false;
                } else if (hsbVals[0] * 360.0f <= 240.0f) {
                    addHue = true;
                }
                net.minecraft.util.text.Color startColor = net.minecraft.util.text.Color.func_240743_a_((int)Color.getHSBColor(addHue ? hsbVals[0] - 0.006f : hsbVals[0] + 0.006f, hsbVals[1], hsbVals[2]).getRGB());
                net.minecraft.util.text.Color endColor = net.minecraft.util.text.Color.func_240743_a_((int)Color.getHSBColor(addHue ? hsbVals[0] + 0.04f : hsbVals[0] - 0.04f, hsbVals[1], hsbVals[2]).getRGB());
                return Pair.of((Object)(startColor.func_240742_a_() & 0xAAFFFFFF), (Object)(endColor.func_240742_a_() & 0x44FFFFFF));
            }
            default: {
                int startColor = LegendaryTooltipsConfig.INSTANCE.getCustomBorderStartColor(frameLevel);
                int endColor = LegendaryTooltipsConfig.INSTANCE.getCustomBorderEndColor(frameLevel);
                if (startColor == -1) {
                    startColor = (Integer)defaults.getLeft();
                }
                if (endColor == -1) {
                    endColor = (Integer)defaults.getRight();
                }
                return Pair.of((Object)startColor, (Object)endColor);
            }
        }
        return defaults;
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        TooltipDecor.updateTimer();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && mc.field_71462_r instanceof ContainerScreen && ((ContainerScreen)mc.field_71462_r).getSlotUnderMouse() != null && ((ContainerScreen)mc.field_71462_r).getSlotUnderMouse().func_75216_d() && lastTooltipItem != ((ContainerScreen)mc.field_71462_r).getSlotUnderMouse().func_75211_c()) {
            TooltipDecor.resetTimer();
            lastTooltipItem = ((ContainerScreen)mc.field_71462_r).getSlotUnderMouse().func_75211_c();
        }
    }

    @SubscribeEvent
    public static void onPreTooltipEvent(RenderTooltipEvent.Pre event) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(event.getStack()) != -2) {
            TooltipDecor.setCachedLines(event.getLines());
        }
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        Pair<Integer, Integer> borderColors = LegendaryTooltips.itemFrameColors(event.getStack(), (Pair<Integer, Integer>)Pair.of((Object)event.getBorderStart(), (Object)event.getBorderEnd()));
        TooltipDecor.setCurrentTooltipBorderStart((Integer)borderColors.getLeft());
        TooltipDecor.setCurrentTooltipBorderEnd((Integer)borderColors.getRight());
        boolean comparison = false;
        if (event instanceof RenderTooltipExtEvent.Color) {
            comparison = ((RenderTooltipExtEvent.Color)event).isComparison();
        }
        if (comparison) {
            event.setBorderStart(0);
            event.setBorderEnd(0);
        } else {
            event.setBorderStart(((Integer)borderColors.getLeft()).intValue());
            event.setBorderEnd(((Integer)borderColors.getRight()).intValue());
        }
    }

    @SubscribeEvent
    public static void onPostTooltipEvent(RenderTooltipEvent.PostText event) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(event.getStack()) == -2) {
            return;
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.tooltipShadow.get()).booleanValue()) {
            TooltipDecor.drawShadow(event.getMatrixStack(), event.getX(), event.getY(), event.getWidth(), event.getHeight());
        }
        boolean comparison = false;
        if (event instanceof RenderTooltipExtEvent.PostText) {
            comparison = ((RenderTooltipExtEvent.PostText)event).isComparison();
        }
        if (comparison) {
            TooltipDecor.drawBorder(event.getMatrixStack(), event.getX(), event.getY() - 11, event.getWidth(), event.getHeight() + 11, event.getStack(), event.getLines(), event.getFontRenderer(), LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(event.getStack()), comparison);
        } else {
            TooltipDecor.drawBorder(event.getMatrixStack(), event.getX(), event.getY(), event.getWidth(), event.getHeight(), event.getStack(), event.getLines(), event.getFontRenderer(), LegendaryTooltipsConfig.INSTANCE.getFrameLevelForItem(event.getStack()), comparison);
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.compatibilityMode.get()).booleanValue()) {
            event.getMatrixStack().func_227861_a_(0.0, 0.0, 500.0);
        }
    }
}

