/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.rlnt.lazierae2.recipe.type.base.AbstractRecipe;
import dev.rlnt.lazierae2.recipe.type.base.MultiRecipe;
import dev.rlnt.lazierae2.recipe.type.base.SingleRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class RecipeUtil {
    private RecipeUtil() {
        throw new IllegalStateException("Utility class");
    }

    private static Ingredient deserializeIngredient(JsonElement element) {
        JsonObject json;
        if (element.isJsonObject() && (json = element.getAsJsonObject()).has("input")) {
            return Ingredient.func_199802_a((JsonElement)json.get("input"));
        }
        return Ingredient.func_199802_a((JsonElement)element);
    }

    public static AbstractRecipe fromJSON(JsonObject json, AbstractRecipe recipe) {
        recipe.setProcessTime(JSONUtils.func_151208_a((JsonObject)json, (String)"processing_time", (int)200));
        recipe.setOutput(ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output")));
        if (recipe instanceof SingleRecipe) {
            ((SingleRecipe)recipe).setInput(Ingredient.func_199802_a((JsonElement)json.get("input")));
        } else {
            JSONUtils.func_151214_t((JsonObject)json, (String)"inputs").forEach(element -> {
                Ingredient input = RecipeUtil.deserializeIngredient(element);
                ((MultiRecipe)recipe).inputs.add((Object)input);
            });
        }
        return recipe;
    }

    public static AbstractRecipe fromNetwork(PacketBuffer buffer, AbstractRecipe recipe) {
        recipe.setProcessTime(buffer.readInt());
        recipe.setOutput(buffer.func_150791_c());
        if (recipe instanceof SingleRecipe) {
            ((SingleRecipe)recipe).setInput(Ingredient.func_199566_b((PacketBuffer)buffer));
        } else {
            ((MultiRecipe)recipe).inputs.clear();
            int inputAmount = buffer.readByte();
            for (int i = 0; i < inputAmount; ++i) {
                ((MultiRecipe)recipe).inputs.add((Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
        }
        return recipe;
    }

    public static void toNetwork(PacketBuffer buffer, AbstractRecipe recipe) {
        buffer.writeInt(recipe.getProcessTime());
        buffer.func_150788_a(recipe.getOutput());
        if (recipe instanceof SingleRecipe) {
            ((SingleRecipe)recipe).getInput().func_199564_a(buffer);
        } else {
            buffer.writeByte(((MultiRecipe)recipe).inputs.size());
            ((MultiRecipe)recipe).inputs.forEach(input -> input.func_199564_a(buffer));
        }
    }
}

