/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.tile.base;

import dev.rlnt.lazierae2.block.base.ProcessorBlock;
import dev.rlnt.lazierae2.inventory.base.AbstractItemHandler;
import dev.rlnt.lazierae2.inventory.base.MultiItemHandler;
import dev.rlnt.lazierae2.inventory.base.SingleItemHandler;
import dev.rlnt.lazierae2.recipe.type.base.AbstractRecipe;
import dev.rlnt.lazierae2.tile.base.IIntArrayIO;
import dev.rlnt.lazierae2.tile.base.MachineTile;
import dev.rlnt.lazierae2.tile.component.AbstractEnergyStorage;
import dev.rlnt.lazierae2.util.GameUtil;
import dev.rlnt.lazierae2.util.IOUtil;
import dev.rlnt.lazierae2.util.TextUtil;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ProcessorTile<I extends AbstractItemHandler, R extends AbstractRecipe>
extends MachineTile<I> {
    public static final int SLOT_UPGRADE = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int INFO_SIZE = 14;
    private final int[] inputSlots;
    private final String id;
    private final AbstractEnergyStorage energyStorage;
    private final LazyOptional<EnergyStorage> energyStorageCap;
    private final LazyOptional<IItemHandlerModifiable>[] sidedInvWrapper;
    private final EnumMap<Direction, LazyOptional<IItemHandler>> cache = new EnumMap(Direction.class);
    private boolean autoExtract = false;
    private EnumMap<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> sideConfig = new EnumMap(TypeEnums.IO_SIDE.class);
    private ItemStack currentStack = ItemStack.field_190927_a;
    private float progress;
    private int effectiveProcessTime;
    protected final IIntArray info = new IIntArrayIO(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return ProcessorTile.this.energyStorage.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return ProcessorTile.this.energyStorage.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return ProcessorTile.this.energyStorage.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return ProcessorTile.this.energyStorage.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return ProcessorTile.this.getEffectiveEnergy();
                }
                case 5: {
                    return (int)ProcessorTile.this.progress;
                }
                case 6: {
                    return ProcessorTile.this.effectiveProcessTime;
                }
                case 7: {
                    return this.getIOSetting(TypeEnums.IO_SIDE.TOP);
                }
                case 8: {
                    return this.getIOSetting(TypeEnums.IO_SIDE.LEFT);
                }
                case 9: {
                    return this.getIOSetting(TypeEnums.IO_SIDE.FRONT);
                }
                case 10: {
                    return this.getIOSetting(TypeEnums.IO_SIDE.RIGHT);
                }
                case 11: {
                    return this.getIOSetting(TypeEnums.IO_SIDE.BOTTOM);
                }
                case 12: {
                    return this.getIOSetting(TypeEnums.IO_SIDE.BACK);
                }
                case 13: {
                    return ProcessorTile.this.autoExtract ? 1 : 0;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            if (index >= 0 && index <= 1) {
                ProcessorTile.this.energyStorage.setEnergy(value);
            }
            if (index >= 2 && index <= 3) {
                ProcessorTile.this.energyStorage.setCapacity(value);
            }
            if (index == 5) {
                ProcessorTile.this.progress = value;
            }
            if (index == 6) {
                ProcessorTile.this.effectiveProcessTime = value;
            }
        }

        public int func_221478_a() {
            return 14;
        }

        @Override
        public int getIOSetting(TypeEnums.IO_SIDE side) {
            if (ProcessorTile.this.sideConfig.size() == 0) {
                return 0;
            }
            return (Integer)IOUtil.getIOSettingsMap().inverse().get(ProcessorTile.this.sideConfig.get((Object)side));
        }
    };
    private ItemStack finishedStack = ItemStack.field_190927_a;

    protected ProcessorTile(TileEntityType<?> tileEntityTypeIn, String id, int[] inputSlots) {
        super(tileEntityTypeIn);
        this.id = id;
        this.inputSlots = inputSlots;
        this.initSideConfig();
        this.energyStorage = new AbstractEnergyStorage(this, this.getEffectiveEnergyCapacity());
        this.energyStorageCap = LazyOptional.of(() -> this.energyStorage);
        this.sidedInvWrapper = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
    }

    public ITextComponent func_145748_c_() {
        return TextUtil.translate(TypeEnums.TRANSLATE_TYPE.CONTAINER, this.id, new TextFormatting[0]);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.energyStorage.deserializeNBT(nbt.func_74775_l("energy"));
        this.itemHandler.setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("upgrade")));
        this.progress = nbt.func_74760_g("progress");
        this.effectiveProcessTime = nbt.func_74762_e("processing_time");
        this.currentStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack_current"));
        this.finishedStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack_output"));
        this.sideConfig = (EnumMap)IOUtil.getSideConfigFromArray(nbt.func_74759_k("io_config"));
        this.autoExtract = nbt.func_74767_n("auto_extract");
        this.refreshEnergyCapacity();
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        nbt.func_218657_a("upgrade", (INBT)this.itemHandler.getStackInSlot(0).func_77955_b(new CompoundNBT()));
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74768_a("processing_time", this.effectiveProcessTime);
        nbt.func_218657_a("stack_current", (INBT)this.currentStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("stack_output", (INBT)this.finishedStack.func_77955_b(new CompoundNBT()));
        nbt.func_74783_a("io_config", IOUtil.serializeSideConfig(this.sideConfig));
        nbt.func_74757_a("auto_extract", this.autoExtract);
        return super.func_189515_b(nbt);
    }

    public void func_145843_s() {
        this.energyStorageCap.invalidate();
        for (LazyOptional<IItemHandlerModifiable> sidedInvCap : this.sidedInvWrapper) {
            sidedInvCap.invalidate();
        }
        super.func_145843_s();
    }

    protected void invalidateCaps() {
        this.energyStorageCap.invalidate();
        for (LazyOptional<IItemHandlerModifiable> sidedInvCap : this.sidedInvWrapper) {
            sidedInvCap.invalidate();
        }
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.func_145837_r()) {
            if (cap == CapabilityEnergy.ENERGY) {
                return this.energyStorageCap.cast();
            }
            if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                switch (side) {
                    case UP: {
                        return this.sidedInvWrapper[0].cast();
                    }
                    case DOWN: {
                        return this.sidedInvWrapper[1].cast();
                    }
                    case NORTH: {
                        return this.sidedInvWrapper[2].cast();
                    }
                    case SOUTH: {
                        return this.sidedInvWrapper[3].cast();
                    }
                    case WEST: {
                        return this.sidedInvWrapper[4].cast();
                    }
                    case EAST: {
                        return this.sidedInvWrapper[5].cast();
                    }
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        R recipe;
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.autoExtract && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.autoExport();
        }
        if ((recipe = this.getRecipe()) != null) {
            int requiredEnergy = this.getEffectiveEnergy();
            if (this.canWork(recipe, requiredEnergy)) {
                this.doWork(recipe, requiredEnergy);
            } else {
                this.setActivityState(false);
            }
        } else {
            this.stopWork();
        }
    }

    public int[] func_180463_a(Direction side) {
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        if (side == facing) {
            return this.getSlotsForIOSide(TypeEnums.IO_SIDE.FRONT);
        }
        if (side == facing.func_176746_e()) {
            return this.getSlotsForIOSide(TypeEnums.IO_SIDE.LEFT);
        }
        if (side == facing.func_176734_d()) {
            return this.getSlotsForIOSide(TypeEnums.IO_SIDE.BACK);
        }
        if (side == facing.func_176735_f()) {
            return this.getSlotsForIOSide(TypeEnums.IO_SIDE.RIGHT);
        }
        if (side == Direction.UP) {
            return this.getSlotsForIOSide(TypeEnums.IO_SIDE.TOP);
        }
        if (side == Direction.DOWN) {
            return this.getSlotsForIOSide(TypeEnums.IO_SIDE.BOTTOM);
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index != 1 && this.itemHandler.isItemValid(index, itemStackIn) && (!(this.itemHandler instanceof MultiItemHandler) || this.itemHandler.getValidSlot(itemStackIn) == index);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    @Nullable
    private R getRecipe() {
        assert (this.field_145850_b != null);
        if (this.itemHandler instanceof SingleItemHandler ? this.itemHandler.getStackInSlot(this.inputSlots[0]).func_190926_b() : Arrays.stream(this.inputSlots).allMatch(slot -> this.itemHandler.getStackInSlot(slot).func_190926_b())) {
            return null;
        }
        return (R)((AbstractRecipe)GameUtil.getRecipeManager(this.field_145850_b).func_215371_a(this.getRecipeType(), (IInventory)this, this.field_145850_b).orElse(null));
    }

    private void stopWork() {
        this.setActivityState(false);
        this.effectiveProcessTime = 0;
        this.progress = 0.0f;
    }

    private void setActivityState(boolean state) {
        R recipe;
        if (this.field_145850_b == null) {
            return;
        }
        BlockState currenState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state && ((Boolean)currenState.func_177229_b((Property)ProcessorBlock.LIT)).equals(false)) {
            this.updateState((BlockState)currenState.func_206870_a((Property)ProcessorBlock.LIT, (Comparable)Boolean.valueOf(true)));
        } else if (!(state || !((Boolean)currenState.func_177229_b((Property)ProcessorBlock.LIT)).equals(true) || (recipe = this.getRecipe()) != null && this.canWork(recipe, this.getEffectiveEnergy()))) {
            this.updateState((BlockState)currenState.func_206870_a((Property)ProcessorBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void updateState(BlockState newState) {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (oldState != newState) {
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
            this.field_145850_b.func_184138_a(this.field_174879_c, oldState, newState, 3);
        }
    }

    private boolean canWork(R recipe, int requiredEnergy) {
        this.currentStack = this.func_70301_a(1);
        this.finishedStack = ((AbstractRecipe)recipe).func_77572_b(this);
        if (requiredEnergy > this.energyStorage.getEnergyStored()) {
            return false;
        }
        if (!this.currentStack.func_190926_b()) {
            int mergeCount = this.currentStack.func_190916_E() + this.finishedStack.func_190916_E();
            return this.currentStack.func_77969_a(this.finishedStack) && mergeCount <= this.finishedStack.func_77976_d() && mergeCount <= this.itemHandler.getSlotLimit(1);
        }
        return true;
    }

    private void doWork(R recipe, int requiredEnergy) {
        this.effectiveProcessTime = this.getEffectiveProcessTime(((AbstractRecipe)recipe).getProcessTime());
        this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() - requiredEnergy);
        if (this.progress < (float)this.effectiveProcessTime) {
            this.setProgress(this.progress + 1.0f);
            this.setActivityState(true);
        }
        if (this.progress >= (float)this.effectiveProcessTime) {
            this.finishWork();
        }
    }

    private void finishWork() {
        if (!this.currentStack.func_190926_b()) {
            this.currentStack.func_190917_f(this.finishedStack.func_190916_E());
        } else {
            this.func_70299_a(1, this.finishedStack);
        }
        if (this.itemHandler instanceof SingleItemHandler) {
            this.func_70298_a(this.inputSlots[0], 1);
        } else {
            for (int slot : this.inputSlots) {
                if (this.func_70301_a(slot).func_190926_b()) continue;
                this.func_70298_a(slot, 1);
            }
        }
        this.stopWork();
    }

    private void autoExport() {
        assert (this.field_145850_b != null);
        if (this.itemHandler.getStackInSlot(1).func_190926_b()) {
            return;
        }
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        EnumMap outputInventories = new EnumMap(Direction.class);
        this.sideConfig.forEach((side, setting) -> {
            if (setting != TypeEnums.IO_SETTING.OUTPUT && setting != TypeEnums.IO_SETTING.IO) {
                return;
            }
            Direction direction = this.getDirection(facing, (TypeEnums.IO_SIDE)((Object)side));
            outputInventories.put(direction, this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(direction, 1)));
        });
        for (Map.Entry entry : outputInventories.entrySet()) {
            LazyOptional target = this.cache.get(entry.getKey());
            if (target == null) {
                ICapabilityProvider provider = (ICapabilityProvider)entry.getValue();
                if (provider == null) continue;
                target = provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, entry.getKey().func_176734_d());
                this.cache.put((Direction)((Enum)entry.getKey()), (LazyOptional<IItemHandler>)target);
                target.addListener(self -> {
                    LazyOptional cfr_ignored_0 = this.cache.put((Direction)((Enum)entry.getKey()), null);
                });
            }
            AtomicBoolean shouldBreak = new AtomicBoolean(false);
            target.ifPresent(targetInventory -> {
                ItemStack toExport = this.itemHandler.getStackInSlot(1);
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)toExport, (boolean)false);
                if (remaining.func_190916_E() != toExport.func_190916_E() || !remaining.func_77969_a(toExport)) {
                    this.itemHandler.setStackInSlot(1, remaining);
                    this.func_70296_d();
                }
                if (remaining.func_190926_b()) {
                    shouldBreak.set(true);
                }
            });
            if (!shouldBreak.get()) continue;
            return;
        }
    }

    private Direction getDirection(Direction facing, TypeEnums.IO_SIDE side) {
        Direction direction;
        switch (side) {
            case TOP: {
                direction = Direction.UP;
                break;
            }
            case LEFT: {
                direction = facing.func_176746_e();
                break;
            }
            case FRONT: {
                direction = facing;
                break;
            }
            case RIGHT: {
                direction = facing.func_176735_f();
                break;
            }
            case BOTTOM: {
                direction = Direction.DOWN;
                break;
            }
            case BACK: {
                direction = facing.func_176734_d();
                break;
            }
            default: {
                throw new IllegalArgumentException("No side found called " + (Object)((Object)side));
            }
        }
        return direction;
    }

    public void refreshEnergyCapacity() {
        this.energyStorage.setCapacity(this.getEffectiveEnergyCapacity());
    }

    protected int getUpgradedValue(int base, double upgrade, TypeEnums.OPERATION_TYPE type) {
        int upgradeAmount = this.getUpgradeStack().func_190916_E();
        if (type == TypeEnums.OPERATION_TYPE.ADD) {
            return (int)((double)base + upgrade * (double)upgradeAmount);
        }
        double pow = Math.pow(upgrade, upgradeAmount);
        return (int)(type == TypeEnums.OPERATION_TYPE.MULTI ? (double)base * pow : (double)base / pow);
    }

    public boolean isWithinProcessorSlots(int index) {
        return index < this.func_70302_i_();
    }

    private void initSideConfig() {
        for (TypeEnums.IO_SIDE side : TypeEnums.IO_SIDE.values()) {
            this.sideConfig.put(side, TypeEnums.IO_SETTING.NONE);
        }
    }

    private int[] getSlotsForIOSide(TypeEnums.IO_SIDE side) {
        TypeEnums.IO_SETTING setting = this.sideConfig.get((Object)side);
        switch (setting) {
            case NONE: {
                return new int[0];
            }
            case INPUT: {
                return this.getInputSlots();
            }
            case OUTPUT: {
                return new int[]{1};
            }
            case IO: {
                return ArrayUtils.addAll((int[])this.getInputSlots(), (int[])new int[]{1});
            }
        }
        throw new IllegalArgumentException("Can't find slots for side " + (Object)((Object)side));
    }

    public ItemStack getBlockItem() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.energyStorage.getEnergyStored() > 0) {
            nbt.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        }
        if (this.getUpgradeStack().func_190916_E() > 0) {
            nbt.func_218657_a("upgrade", (INBT)this.itemHandler.getStackInSlot(0).func_77955_b(new CompoundNBT()));
        }
        if (IOUtil.isChanged(this.sideConfig)) {
            nbt.func_74783_a("io_config", IOUtil.serializeSideConfig(this.sideConfig));
        }
        if (this.autoExtract) {
            nbt.func_74757_a("auto_extract", true);
        }
        ItemStack stack = new ItemStack(this.getItemProvider());
        if (!nbt.isEmpty()) {
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    public void setSideConfig(Map<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> sideConfig) {
        this.sideConfig = (EnumMap)sideConfig;
        this.func_70296_d();
    }

    private void setProgress(float progress) {
        this.progress = progress;
        this.func_70296_d();
    }

    public void toggleAutoExtract() {
        this.autoExtract = !this.autoExtract;
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    public ItemStack getUpgradeStack() {
        if (this.itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        return this.itemHandler.getStackInSlot(0);
    }

    public AbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    protected abstract IItemProvider getItemProvider();

    protected abstract IRecipeType<R> getRecipeType();

    protected abstract int getEffectiveEnergyCapacity();

    protected abstract int getEffectiveEnergy();

    protected abstract int getEffectiveProcessTime(int var1);
}

