/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.tile;

import dev.rlnt.lazierae2.container.CentrifugeContainer;
import dev.rlnt.lazierae2.inventory.CentrifugeItemHandler;
import dev.rlnt.lazierae2.inventory.base.SingleItemHandler;
import dev.rlnt.lazierae2.recipe.type.CentrifugeRecipe;
import dev.rlnt.lazierae2.setup.ModBlocks;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.setup.ModRecipes;
import dev.rlnt.lazierae2.setup.ModTiles;
import dev.rlnt.lazierae2.tile.base.ProcessorTile;
import dev.rlnt.lazierae2.util.TypeEnums;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public class CentrifugeTile
extends ProcessorTile<SingleItemHandler, CentrifugeRecipe> {
    private static final int SLOT_AMOUNT = 3;
    private static final int[] SLOT_INPUTS = new int[]{2};

    public CentrifugeTile() {
        super((TileEntityType)ModTiles.CENTRIFUGE.get(), "pulse_centrifuge", SLOT_INPUTS);
        this.itemHandler = new CentrifugeItemHandler(3, this);
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory inventory, PlayerEntity player) {
        return new CentrifugeContainer(windowID, inventory, this, this.info);
    }

    @Override
    protected IItemProvider getItemProvider() {
        return (IItemProvider)ModBlocks.CENTRIFUGE.get();
    }

    @Override
    protected IRecipeType<CentrifugeRecipe> getRecipeType() {
        return ModRecipes.Types.CENTRIFUGE;
    }

    @Override
    protected int getEffectiveEnergyCapacity() {
        int baseBuffer = (Integer)ModConfig.PROCESSING.centrifugeEnergyBuffer.get();
        double upgradeBuffer = ((Integer)ModConfig.PROCESSING.centrifugeEnergyBufferUpgrade.get()).intValue();
        return this.getUpgradedValue(baseBuffer, upgradeBuffer, TypeEnums.OPERATION_TYPE.ADD);
    }

    @Override
    public int getEffectiveEnergy() {
        int baseEnergy = (Integer)ModConfig.PROCESSING.centrifugeEnergyCostBase.get();
        double upgradeEnergy = (Double)ModConfig.PROCESSING.centrifugeEnergyCostUpgrade.get();
        return this.getUpgradedValue(baseEnergy, upgradeEnergy, TypeEnums.OPERATION_TYPE.MULTI);
    }

    @Override
    public int getEffectiveProcessTime(int baseProcessingTime) {
        double upgradProcessingTime = (Double)ModConfig.PROCESSING.centrifugeWorkTicksUpgrade.get();
        return this.getUpgradedValue(baseProcessingTime, upgradProcessingTime, TypeEnums.OPERATION_TYPE.DIV);
    }

    public int func_70302_i_() {
        return 3;
    }
}

