/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.setup;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final Processing PROCESSING;
    public static final ForgeConfigSpec processingSpec;

    private ModConfig() {
        throw new IllegalStateException("Config class");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Processing::new);
        PROCESSING = (Processing)specPair.getLeft();
        processingSpec = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Processing {
        static final String ENERGY_BUFFER = "energyBuffer";
        static final String ENERGY_BUFFER_UPGRADE = "energyBufferUpgrade";
        static final String ENERGY_BUFFER_CALCULATION = "Calculation: bufferBase + bufferUpgrade * upgradeAmount)";
        static final String ENERGY_COST_BASE = "energyCostBase";
        static final String ENERGY_COST_UPGRADE = "energyCostUpgrade";
        static final String ENERGY_COST_CALCULATION = "Calculation: energyBase * (energyUpgrade ^ upgradeAmount)";
        static final String WORKER_TICKS_BASE = "workerTicksBase";
        static final String WORKER_TICKS_UPGRADE = "workerTicksUpgrade";
        static final String WORKER_TICKS_USAGE = "This value will be used on recipes with no explicit processing time.";
        static final String WORKER_TICKS_EFFECT = "This only takes effect when custom recipes are added.";
        static final String WORKER_TICKS_CALCULATION = "Calculation: speedBase * (speedUpgrade ^ upgradeAmount)";
        static final String WORKER_TICKS_SPEED = "The speed is the reverse value of the processing time. The higher the time, the lower the speed.";
        public final ForgeConfigSpec.IntValue processorUpgradeSlots;
        public final ForgeConfigSpec.IntValue aggregatorEnergyBuffer;
        public final ForgeConfigSpec.IntValue aggregatorEnergyBufferUpgrade;
        public final ForgeConfigSpec.IntValue aggregatorEnergyCostBase;
        public final ForgeConfigSpec.DoubleValue aggregatorEnergyCostUpgrade;
        public final ForgeConfigSpec.IntValue aggregatorWorkTicksBase;
        public final ForgeConfigSpec.DoubleValue aggregatorWorkTicksUpgrade;
        public final ForgeConfigSpec.IntValue centrifugeEnergyBuffer;
        public final ForgeConfigSpec.IntValue centrifugeEnergyBufferUpgrade;
        public final ForgeConfigSpec.IntValue centrifugeEnergyCostBase;
        public final ForgeConfigSpec.DoubleValue centrifugeEnergyCostUpgrade;
        public final ForgeConfigSpec.IntValue centrifugeWorkTicksBase;
        public final ForgeConfigSpec.DoubleValue centrifugeWorkTicksUpgrade;
        public final ForgeConfigSpec.IntValue energizerEnergyBuffer;
        public final ForgeConfigSpec.IntValue energizerEnergyBufferUpgrade;
        public final ForgeConfigSpec.IntValue energizerEnergyCostBase;
        public final ForgeConfigSpec.DoubleValue energizerEnergyCostUpgrade;
        public final ForgeConfigSpec.IntValue energizerWorkTicksBase;
        public final ForgeConfigSpec.DoubleValue energizerWorkTicksUpgrade;
        public final ForgeConfigSpec.IntValue etcherEnergyBuffer;
        public final ForgeConfigSpec.IntValue etcherEnergyBufferUpgrade;
        public final ForgeConfigSpec.IntValue etcherEnergyCostBase;
        public final ForgeConfigSpec.DoubleValue etcherEnergyCostUpgrade;
        public final ForgeConfigSpec.IntValue etcherWorkTicksBase;
        public final ForgeConfigSpec.DoubleValue etcherWorkTicksUpgrade;

        Processing(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"#########################################################################################", "You can edit a lot of values for the different processors of the mod here.", "", "When the config mentions 'processors', all machines which produce materials are meant.", "Processors: Fluix Aggregator, Pulse Centrifuge, Crystal Energizer, Circuit Etcher", "", "When there is an option writing about 'upgrades', Acceleration Cards from AE2 are meant.", "#########################################################################################"});
            builder.push("general");
            this.processorUpgradeSlots = builder.comment(new String[]{"The maximum amount of acceleration cards which can be stored in a processor.", "Upgrades will speed up the processing and increase the energy buffer at the cost of a higher energy consumption."}).translation(Processing.translationKey("processor", "upgradeSlots")).defineInRange("upgradeSlots", 8, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("fluix_aggregator");
            this.aggregatorEnergyBuffer = builder.comment("The base size of the Fluix Aggregator's energy buffer.").translation(Processing.translationKey("fluix_aggregator", ENERGY_BUFFER)).defineInRange(ENERGY_BUFFER, 200000, 1, Integer.MAX_VALUE);
            this.aggregatorEnergyBufferUpgrade = builder.comment(new String[]{"The additional size the Fluix Aggregator's energy buffer increases per upgrade.", ENERGY_BUFFER_CALCULATION}).translation(Processing.translationKey("fluix_aggregator", ENERGY_BUFFER_UPGRADE)).defineInRange(ENERGY_BUFFER_UPGRADE, 100000, 1, Integer.MAX_VALUE);
            this.aggregatorEnergyCostBase = builder.comment("The base energy cost per tick of the Fluix Aggregator.").translation(Processing.translationKey("fluix_aggregator", ENERGY_COST_BASE)).defineInRange(ENERGY_COST_BASE, 100, 1, Integer.MAX_VALUE);
            this.aggregatorEnergyCostUpgrade = builder.comment(new String[]{"The multiplicator of how much the Fluix Aggregator's energy cost per tick increases per upgrade.", ENERGY_COST_CALCULATION}).translation(Processing.translationKey("fluix_aggregator", ENERGY_COST_UPGRADE)).defineInRange(ENERGY_COST_UPGRADE, 1.3, 1.0, Double.MAX_VALUE);
            this.aggregatorWorkTicksBase = builder.comment(new String[]{"The base number of ticks needed to process one Fluix Aggregator recipe.", WORKER_TICKS_USAGE, WORKER_TICKS_EFFECT}).translation(Processing.translationKey("fluix_aggregator", WORKER_TICKS_BASE)).defineInRange(WORKER_TICKS_BASE, 80, 1, Integer.MAX_VALUE);
            this.aggregatorWorkTicksUpgrade = builder.comment(new String[]{"The multiplicator of how much the Fluix Aggregator's processing speed per recipe increases per upgrade.", WORKER_TICKS_CALCULATION, WORKER_TICKS_SPEED}).translation(Processing.translationKey("fluix_aggregator", WORKER_TICKS_UPGRADE)).defineInRange(WORKER_TICKS_UPGRADE, 1.25, 1.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("pulse_centrifuge");
            this.centrifugeEnergyBuffer = builder.comment("The base size of the Pulse Centrifuge's energy buffer.").translation(Processing.translationKey("pulse_centrifuge", ENERGY_BUFFER)).defineInRange(ENERGY_BUFFER, 400000, 1, Integer.MAX_VALUE);
            this.centrifugeEnergyBufferUpgrade = builder.comment(new String[]{"The additional size the Pulse Centrifuge's energy buffer increases per upgrade.", ENERGY_BUFFER_CALCULATION}).translation(Processing.translationKey("pulse_centrifuge", ENERGY_BUFFER_UPGRADE)).defineInRange(ENERGY_BUFFER_UPGRADE, 200000, 1, Integer.MAX_VALUE);
            this.centrifugeEnergyCostBase = builder.comment("The base energy cost per tick of the Pulse Centrifuge.").translation(Processing.translationKey("pulse_centrifuge", ENERGY_COST_BASE)).defineInRange(ENERGY_COST_BASE, 150, 1, Integer.MAX_VALUE);
            this.centrifugeEnergyCostUpgrade = builder.comment(new String[]{"The multiplicator of how much the Pulse Centrifuge's energy cost per tick increases per upgrade.", ENERGY_COST_CALCULATION}).translation(Processing.translationKey("pulse_centrifuge", ENERGY_COST_UPGRADE)).defineInRange(ENERGY_COST_UPGRADE, 1.3, 1.0, Double.MAX_VALUE);
            this.centrifugeWorkTicksBase = builder.comment(new String[]{"The base number of ticks needed to process one Pulse Centrifuge recipe.", WORKER_TICKS_USAGE, WORKER_TICKS_EFFECT}).translation(Processing.translationKey("pulse_centrifuge", WORKER_TICKS_BASE)).defineInRange(WORKER_TICKS_BASE, 160, 1, Integer.MAX_VALUE);
            this.centrifugeWorkTicksUpgrade = builder.comment(new String[]{"The multiplicator of how much the Pulse Centrifuge's processing speed per recipe increases per upgrade.", WORKER_TICKS_CALCULATION, WORKER_TICKS_SPEED}).translation(Processing.translationKey("pulse_centrifuge", WORKER_TICKS_UPGRADE)).defineInRange(WORKER_TICKS_UPGRADE, 1.25, 1.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("crystal_energizer");
            this.energizerEnergyBuffer = builder.comment("The base size of the Crystal Energizer's energy buffer.").translation(Processing.translationKey("crystal_energizer", ENERGY_BUFFER)).defineInRange(ENERGY_BUFFER, 200000, 1, Integer.MAX_VALUE);
            this.energizerEnergyBufferUpgrade = builder.comment(new String[]{"The additional size the Crystal Energizer's energy buffer increases per upgrade.", ENERGY_BUFFER_CALCULATION}).translation(Processing.translationKey("crystal_energizer", ENERGY_BUFFER_UPGRADE)).defineInRange(ENERGY_BUFFER_UPGRADE, 100000, 1, Integer.MAX_VALUE);
            this.energizerEnergyCostBase = builder.comment("The base energy cost per tick of the Crystal Energizer.").translation(Processing.translationKey("crystal_energizer", ENERGY_COST_BASE)).defineInRange(ENERGY_COST_BASE, 60, 1, Integer.MAX_VALUE);
            this.energizerEnergyCostUpgrade = builder.comment(new String[]{"The multiplicator of how much the Crystal Energizer's energy cost per tick increases per upgrade.", ENERGY_COST_CALCULATION}).translation(Processing.translationKey("crystal_energizer", ENERGY_COST_UPGRADE)).defineInRange(ENERGY_COST_UPGRADE, 1.35, 1.0, Double.MAX_VALUE);
            this.energizerWorkTicksBase = builder.comment(new String[]{"The base number of ticks needed to process one Crystal Energizer recipe.", WORKER_TICKS_USAGE, WORKER_TICKS_EFFECT}).translation(Processing.translationKey("crystal_energizer", WORKER_TICKS_BASE)).defineInRange(WORKER_TICKS_BASE, 100, 1, Integer.MAX_VALUE);
            this.energizerWorkTicksUpgrade = builder.comment(new String[]{"The multiplicator of how much the Crystal Energizer's processing speed per recipe increases per upgrade.", WORKER_TICKS_CALCULATION, WORKER_TICKS_SPEED}).translation(Processing.translationKey("crystal_energizer", WORKER_TICKS_UPGRADE)).defineInRange(WORKER_TICKS_UPGRADE, 1.3, 1.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("circuit_etcher");
            this.etcherEnergyBuffer = builder.comment("The base size of the Circuit Etcher's energy buffer.").translation(Processing.translationKey("circuit_etcher", ENERGY_BUFFER)).defineInRange(ENERGY_BUFFER, 400000, 1, Integer.MAX_VALUE);
            this.etcherEnergyBufferUpgrade = builder.comment(new String[]{"The additional size the Circuit Etcher's energy buffer increases per upgrade.", ENERGY_BUFFER_CALCULATION}).translation(Processing.translationKey("circuit_etcher", ENERGY_BUFFER_UPGRADE)).defineInRange(ENERGY_BUFFER_UPGRADE, 200000, 1, Integer.MAX_VALUE);
            this.etcherEnergyCostBase = builder.comment("The base energy cost per tick of the Circuit Etcher.").translation(Processing.translationKey("circuit_etcher", ENERGY_COST_BASE)).defineInRange(ENERGY_COST_BASE, 250, 1, Integer.MAX_VALUE);
            this.etcherEnergyCostUpgrade = builder.comment(new String[]{"The multiplicator of how much the Circuit Etcher's energy cost per tick increases per upgrade.", ENERGY_COST_CALCULATION}).translation(Processing.translationKey("circuit_etcher", ENERGY_COST_UPGRADE)).defineInRange(ENERGY_COST_UPGRADE, 1.26, 1.0, Double.MAX_VALUE);
            this.etcherWorkTicksBase = builder.comment(new String[]{"The base number of ticks needed to process one Circuit Etcher recipe.", WORKER_TICKS_USAGE, WORKER_TICKS_EFFECT}).translation(Processing.translationKey("circuit_etcher", WORKER_TICKS_BASE)).defineInRange(WORKER_TICKS_BASE, 120, 1, Integer.MAX_VALUE);
            this.etcherWorkTicksUpgrade = builder.comment(new String[]{"The multiplicator of how much the Circuit Etcher's processing speed per recipe increases per upgrade.", WORKER_TICKS_CALCULATION, WORKER_TICKS_SPEED}).translation(Processing.translationKey("circuit_etcher", WORKER_TICKS_UPGRADE)).defineInRange(WORKER_TICKS_UPGRADE, 1.2, 1.0, Double.MAX_VALUE);
            builder.pop();
        }

        private static String translationKey(String machine, String id) {
            return "lazierae2.config." + machine + "." + id;
        }
    }
}

