/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.screen.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.rlnt.lazierae2.container.base.ProcessorContainer;
import dev.rlnt.lazierae2.screen.base.AbstractButton;
import dev.rlnt.lazierae2.screen.base.ProcessorScreen;
import dev.rlnt.lazierae2.util.IOUtil;
import dev.rlnt.lazierae2.util.TextUtil;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class IOButton
extends AbstractButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("lazierae2", "textures/gui/component/io.png");
    private static final int BUTTON_POS_X = 146;
    private static final int BUTTON_POS_Y = 7;
    private static final int BUTTON_WIDTH = 17;
    private static final int BUTTON_HEIGHT = 17;
    private static final int FIELD_SIZE_INNER = 5;
    private static final int FIELD_SIZE = 6;
    private final ProcessorScreen<?> parent;
    private final IOField[] ioFields;
    private final Map<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> currentIOSettings;

    public IOButton(ProcessorScreen<?> parent, Button.IPressable onPress) {
        super(parent, 146, 7, 17, 17, false, onPress);
        this.parent = parent;
        this.ioFields = this.setupIOFields();
        this.currentIOSettings = this.getSyncedSideConfig();
    }

    @Override
    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        for (IOField field : this.ioFields) {
            this.renderIOField(matrix, field);
        }
        if (this.field_230692_n_) {
            this.func_230443_a_(matrix, mouseX, mouseY);
        }
    }

    @Override
    protected int getTextureWidth() {
        return this.field_230688_j_ + 5;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getUOffset() {
        return 0;
    }

    public void func_230443_a_(MatrixStack matrix, int mouseX, int mouseY) {
        for (IOField field : this.ioFields) {
            if (!field.mouseOver(mouseX, mouseY)) continue;
            ArrayList<Object> tooltips = new ArrayList<Object>();
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.BUTTON, "io_header", TextFormatting.GOLD));
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.BUTTON, "io_side", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s", TextUtil.translate(TypeEnums.TRANSLATE_TYPE.IO_SIDE, TextUtil.translateIOSide(field.side), new TextFormatting[0]).getString()), TextFormatting.WHITE)));
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.BUTTON, "io_mode", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s", TextUtil.translate(TypeEnums.TRANSLATE_TYPE.IO_SETTING, TextUtil.translateIOSetting(field.getSettingForSide()), new TextFormatting[0]).getString()), TextFormatting.WHITE)));
            this.parent.func_243308_b(matrix, tooltips, mouseX, mouseY);
        }
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        for (IOField field : this.ioFields) {
            if (!field.mouseOver((int)mouseX, (int)mouseY)) continue;
            field.changeMode(Screen.func_231173_s_());
            break;
        }
        super.func_230982_a_(mouseX, mouseY);
    }

    private IOField[] setupIOFields() {
        IOField[] fields = new IOField[6];
        int i = -1;
        fields[++i] = new IOField(TypeEnums.IO_SIDE.TOP, this.field_230690_l_ + 6, this.field_230691_m_ + 1);
        fields[++i] = new IOField(TypeEnums.IO_SIDE.LEFT, this.field_230690_l_ + 1, this.field_230691_m_ + 6);
        fields[++i] = new IOField(TypeEnums.IO_SIDE.FRONT, this.field_230690_l_ + 6, this.field_230691_m_ + 6);
        fields[++i] = new IOField(TypeEnums.IO_SIDE.RIGHT, this.field_230690_l_ + 6 + 5, this.field_230691_m_ + 6);
        fields[++i] = new IOField(TypeEnums.IO_SIDE.BOTTOM, this.field_230690_l_ + 6, this.field_230691_m_ + 6 + 5);
        fields[++i] = new IOField(TypeEnums.IO_SIDE.BACK, this.field_230690_l_ + 6 + 5, this.field_230691_m_ + 6 + 5);
        return fields;
    }

    private void renderIOField(MatrixStack matrix, IOField field) {
        int sideOffset = field.getVOffset();
        if (sideOffset >= 0) {
            IOButton.func_238463_a_((MatrixStack)matrix, (int)field.x, (int)field.y, (float)this.field_230688_j_, (float)sideOffset, (int)5, (int)5, (int)(this.field_230688_j_ + 5), (int)this.field_230689_k_);
        }
    }

    public Map<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> getCurrentIOSettings() {
        return this.currentIOSettings;
    }

    private EnumMap<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> getSyncedSideConfig() {
        return ((ProcessorContainer)this.parent.func_212873_a_()).getSideConfig();
    }

    private class IOField {
        private final TypeEnums.IO_SIDE side;
        private final int x;
        private final int y;

        IOField(TypeEnums.IO_SIDE side, int x, int y) {
            this.side = side;
            this.x = x;
            this.y = y;
        }

        private boolean mouseOver(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX < this.x + 5 && mouseY >= this.y && mouseY < this.y + 5;
        }

        private int getVOffset() {
            return (Integer)IOUtil.getIOSettingsMap().inverse().get((Object)this.getSettingForSide()) * 5 - 5;
        }

        private TypeEnums.IO_SETTING getSettingForSide() {
            TypeEnums.IO_SETTING setting = (TypeEnums.IO_SETTING)((Object)IOButton.this.getSyncedSideConfig().get((Object)this.side));
            IOButton.this.currentIOSettings.replace(this.side, setting);
            return setting;
        }

        private void changeMode(boolean reset) {
            if (reset) {
                IOButton.this.currentIOSettings.replace(this.side, TypeEnums.IO_SETTING.NONE);
                return;
            }
            TypeEnums.IO_SETTING setting = this.getSettingForSide();
            switch (setting) {
                case NONE: {
                    setting = TypeEnums.IO_SETTING.INPUT;
                    break;
                }
                case INPUT: {
                    setting = TypeEnums.IO_SETTING.OUTPUT;
                    break;
                }
                case OUTPUT: {
                    setting = TypeEnums.IO_SETTING.IO;
                    break;
                }
                case IO: {
                    setting = TypeEnums.IO_SETTING.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("There is no IO mode called " + (Object)((Object)setting));
                }
            }
            IOButton.this.currentIOSettings.replace(this.side, setting);
        }
    }
}

