/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.screen.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.rlnt.lazierae2.container.base.ProcessorContainer;
import dev.rlnt.lazierae2.inventory.component.UpgradeSlot;
import dev.rlnt.lazierae2.network.EnergyResetPacket;
import dev.rlnt.lazierae2.network.ExtractTogglePacket;
import dev.rlnt.lazierae2.network.IOUpdatePacket;
import dev.rlnt.lazierae2.network.PacketHandler;
import dev.rlnt.lazierae2.screen.base.MachineScreen;
import dev.rlnt.lazierae2.screen.components.DumpButton;
import dev.rlnt.lazierae2.screen.components.ExtractButton;
import dev.rlnt.lazierae2.screen.components.IOButton;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.util.IOUtil;
import dev.rlnt.lazierae2.util.TextUtil;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ProcessorScreen<C extends ProcessorContainer<?>>
extends MachineScreen<C> {
    private static final int ENERGY_BAR_POS_X = 166;
    private static final int ENERGY_BAR_POS_Y = 78;
    private static final int ENERGY_BAR_OFFSET_U = 176;
    private static final int ENERGY_BAR_WIDTH = 2;
    private static final int ENERGY_BAR_HEIGHT = 70;
    private static final int PROGRESS_BAR_OFFSET_U = 178;

    protected ProcessorScreen(C container, PlayerInventory inventory, ITextComponent title, String texture, int atlasWidth) {
        super(container, inventory, title, texture, atlasWidth);
    }

    public static TranslationTextComponent getDetailsTooltip() {
        return (TranslationTextComponent)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "shift_details_1", TextFormatting.GRAY).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtil.colorize(InputMappings.func_197955_a((String)"key.keyboard.left.shift").func_237520_d_().getString(), TextFormatting.AQUA)).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "shift_details_2", TextFormatting.GRAY));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new DumpButton(this, button -> PacketHandler.channel.sendToServer((Object)new EnergyResetPacket())));
        this.func_230480_a_((Widget)new ExtractButton(this, button -> PacketHandler.channel.sendToServer((Object)new ExtractTogglePacket())));
        this.func_230480_a_((Widget)new IOButton(this, button -> PacketHandler.channel.sendToServer((Object)new IOUpdatePacket(IOUtil.serializeSideConfig(((IOButton)button).getCurrentIOSettings())))));
    }

    protected void func_230459_a_(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.isWithinRegion(mouseX, mouseY, 165, 169, 7, 79)) {
            ArrayList<Object> tooltips = new ArrayList<Object>();
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "energy_buffer", TextFormatting.GOLD));
            tooltips.add(StringTextComponent.field_240750_d_);
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "energy_stored", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s / %s", TextUtil.formatEnergy(((ProcessorContainer)this.field_147002_h).getEnergyStored(), ProcessorScreen.func_231173_s_()), TextUtil.formatEnergy(((ProcessorContainer)this.field_147002_h).getEnergyCapacity(), ProcessorScreen.func_231173_s_())), TextFormatting.WHITE)));
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "energy_rate", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s/t", TextUtil.formatEnergy(((ProcessorContainer)this.field_147002_h).getEffectiveEnergyConsumption(), ProcessorScreen.func_231173_s_())), TextFormatting.WHITE)));
            if (!ProcessorScreen.func_231173_s_()) {
                tooltips.add(StringTextComponent.field_240750_d_);
                tooltips.add(ProcessorScreen.getDetailsTooltip());
            }
            this.func_243308_b(matrix, tooltips, mouseX, mouseY);
            return;
        }
        if (this.field_147006_u instanceof UpgradeSlot) {
            int upgradeAmount = this.field_147006_u.func_75211_c().func_190916_E();
            ArrayList<Object> tooltips = new ArrayList<Object>();
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "upgrade_slot", TextFormatting.GOLD));
            tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "upgrade_amount", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s / %s", upgradeAmount, ModConfig.PROCESSING.processorUpgradeSlots.get()), TextFormatting.WHITE)));
            if (this.field_147006_u.func_75216_d()) {
                tooltips.add(StringTextComponent.field_240750_d_);
                tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "upgrade_processing_multiplier", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" x%s", TextUtil.formatNumber(((ProcessorContainer)this.field_147002_h).getProcessTimeMultiplier(upgradeAmount), 1, ProcessorScreen.func_231173_s_() ? 6 : 3)), TextFormatting.WHITE)));
                tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "upgrade_consumption_multiplier", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" x%s", TextUtil.formatNumber(Float.valueOf(((ProcessorContainer)this.field_147002_h).getEnergyConsumptionMultiplier()), 1, ProcessorScreen.func_231173_s_() ? 6 : 3)), TextFormatting.WHITE)));
                tooltips.add(TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "upgrade_capacity_additional", TextFormatting.GREEN).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s", TextUtil.formatEnergy(((ProcessorContainer)this.field_147002_h).getEnergyCapacityAdditional(), ProcessorScreen.func_231173_s_())), TextFormatting.WHITE)));
                if (!ProcessorScreen.func_231173_s_()) {
                    tooltips.add(StringTextComponent.field_240750_d_);
                    tooltips.add(ProcessorScreen.getDetailsTooltip());
                }
            }
            this.func_243308_b(matrix, tooltips, mouseX, mouseY);
            return;
        }
        super.func_230459_a_(matrix, mouseX, mouseY);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrix, partialTicks, mouseX, mouseY);
        this.draw(matrix, 166, 78 - this.getEnergyBarHeight(), 176, 2, this.getEnergyBarHeight());
    }

    protected void drawProgressBar(MatrixStack matrix, int posX, int posY, int width, int height, TypeEnums.PROGRESS_BAR_TYPE type) {
        if (!((ProcessorContainer)this.field_147002_h).isProcessing()) {
            return;
        }
        int offsetU = 178;
        float progress = ((ProcessorContainer)this.field_147002_h).getProgress();
        float processTime = ((ProcessorContainer)this.field_147002_h).getEffectiveProcessTime();
        switch (type) {
            case PRIMARY: {
                float length = (progress - processTime / 2.0f) * (float)width / (processTime / 2.0f);
                break;
            }
            case SECONDARY: {
                float length = progress * 2.0f * (float)width / processTime;
                offsetU = 200;
                break;
            }
            default: {
                float length = progress * (float)width / processTime;
            }
        }
        this.draw(matrix, posX, posY, offsetU, MathHelper.func_76125_a((int)((int)(length += 1.0f)), (int)0, (int)width), height);
    }

    private int getEnergyBarHeight() {
        int max = ((ProcessorContainer)this.field_147002_h).getEnergyCapacity();
        int energy = MathHelper.func_76125_a((int)((ProcessorContainer)this.field_147002_h).getEnergyStored(), (int)0, (int)max);
        return max > 0 ? energy * 70 / max : 0;
    }

    private boolean isWithinRegion(int mouseX, int mouseY, int leftBound, int rightBound, int topBound, int bottomBound) {
        return mouseX >= this.field_147003_i + leftBound && mouseX <= this.field_147003_i + rightBound && mouseY >= this.field_147009_r + topBound && mouseY <= this.field_147009_r + bottomBound;
    }
}

