/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.recipe.builder.base;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractRecipeBuilder {
    protected final ItemStack output;
    protected int processingTime = 0;
    protected String id;

    AbstractRecipeBuilder(IItemProvider output, int outputCount) {
        this.output = new ItemStack(output, outputCount);
        this.id = this.getId();
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation outputID = this.output.func_77973_b().getRegistryName();
        String modID = "minecraft".equals(Objects.requireNonNull(outputID).func_110624_b()) ? "lazierae2" : outputID.func_110624_b();
        ResourceLocation recipeID = new ResourceLocation(modID, this.id + "/" + outputID.func_110623_a());
        this.checkProcessingTime();
        this.build(consumer, recipeID);
    }

    protected abstract void build(Consumer<IFinishedRecipe> var1, ResourceLocation var2);

    protected abstract String getId();

    protected abstract void checkProcessingTime();
}

