/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.inventory.base;

import dev.rlnt.lazierae2.inventory.base.AbstractItemHandler;
import dev.rlnt.lazierae2.recipe.type.base.MultiRecipe;
import dev.rlnt.lazierae2.tile.base.ProcessorTile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public abstract class MultiItemHandler
extends AbstractItemHandler {
    private final Set<Ingredient> slot1Valids = new HashSet<Ingredient>();
    private final Set<Ingredient> slot2Valids = new HashSet<Ingredient>();
    private final Set<Ingredient> slot3Valids = new HashSet<Ingredient>();

    protected MultiItemHandler(int size, ProcessorTile<?, ?> tile) {
        super(size, tile);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (Arrays.stream(this.tile.getInputSlots()).anyMatch(inputSlot -> inputSlot == slot)) {
            return this.isInput(stack);
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    public int getValidSlot(ItemStack stack) {
        int[] inputSlots = this.tile.getInputSlots();
        ItemStack slot1Stack = this.getStackInSlot(inputSlots[0]);
        if ((slot1Stack.func_190926_b() || stack.func_77969_a(slot1Stack)) && this.slot1Valids.stream().anyMatch(element -> element.test(stack))) {
            return inputSlots[0];
        }
        ItemStack slot2Stack = this.getStackInSlot(inputSlots[1]);
        if ((slot2Stack.func_190926_b() || stack.func_77969_a(slot2Stack)) && this.slot2Valids.stream().anyMatch(element -> element.test(stack))) {
            return inputSlots[1];
        }
        ItemStack slot3Stack = this.getStackInSlot(inputSlots[2]);
        if ((slot3Stack.func_190926_b() || stack.func_77969_a(slot3Stack)) && this.slot3Valids.stream().anyMatch(element -> element.test(stack))) {
            return inputSlots[2];
        }
        return -1;
    }

    protected void fillRecipeValidSlots(MultiRecipe recipe) {
        NonNullList<Ingredient> inputs = recipe.getInputs();
        if (!inputs.isEmpty()) {
            this.slot1Valids.add((Ingredient)recipe.getInputs().get(0));
        }
        if (inputs.size() > 1) {
            this.slot2Valids.add((Ingredient)recipe.getInputs().get(1));
        }
        if (inputs.size() > 2) {
            this.slot3Valids.add((Ingredient)recipe.getInputs().get(2));
        }
    }

    protected abstract boolean isInput(ItemStack var1);
}

