/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.integration.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.rlnt.lazierae2.integration.jei.category.base.ModRecipeCategory;
import dev.rlnt.lazierae2.recipe.type.EnergizerRecipe;
import dev.rlnt.lazierae2.setup.ModBlocks;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.util.TextUtil;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class EnergizerCategory
extends ModRecipeCategory<EnergizerRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("lazierae2", "crystal_energizer");
    private static final int TEXTURE_WIDTH = 90;
    private static final int TEXTURE_HEIGHT = 47;
    private static final int TEXTURE_OFFSET_U = 51;
    private static final int TEXTURE_OFFSET_V = 26;
    private static final int PROGRESS_BAR_OFFSET_U = 30;
    private static final int PROGRESS_BAR_OFFSET_V = 3;

    public EnergizerCategory(IGuiHelper guiHelper) {
        super(guiHelper, "crystal_energizer");
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends EnergizerRecipe> getRecipeClass() {
        return EnergizerRecipe.class;
    }

    public void setRecipe(IRecipeLayout recipeLayout, EnergizerRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        this.initSlot(itemStackGroup, 1, false, 65, 9);
        this.initSlot(itemStackGroup, 2, true, 5, 9);
        itemStackGroup.set(ingredients);
    }

    @Override
    public void draw(EnergizerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, matrixStack, mouseX, mouseY);
        Minecraft.func_71410_x().field_71466_p.func_238405_a_(matrixStack, TextUtil.formatEnergy(recipe.getProcessTime() * (Integer)ModConfig.PROCESSING.energizerEnergyCostBase.get(), false), 3.0f, 36.0f, -1);
    }

    @Override
    protected int getAtlasWidth() {
        return 200;
    }

    @Override
    protected int getTextureWidth() {
        return 90;
    }

    @Override
    protected int getTextureHeight() {
        return 47;
    }

    @Override
    protected int getTextureOffsetU() {
        return 51;
    }

    @Override
    protected int getTextureOffsetV() {
        return 26;
    }

    @Override
    protected int getProgressBarWidth() {
        return 22;
    }

    @Override
    protected int getProgressBarHeight() {
        return 29;
    }

    @Override
    protected int getProgressBarOffsetU() {
        return 30;
    }

    @Override
    protected int getProgressBarOffsetV() {
        return 3;
    }

    @Override
    protected IItemProvider getIconProvider() {
        return (IItemProvider)ModBlocks.ENERGIZER.get();
    }
}

