/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.container.base;

import dev.rlnt.lazierae2.container.base.IInfo;
import dev.rlnt.lazierae2.container.base.MachineContainer;
import dev.rlnt.lazierae2.inventory.base.AbstractItemHandler;
import dev.rlnt.lazierae2.inventory.base.SingleItemHandler;
import dev.rlnt.lazierae2.inventory.component.OutputSlot;
import dev.rlnt.lazierae2.inventory.component.UpgradeSlot;
import dev.rlnt.lazierae2.tile.base.ProcessorTile;
import dev.rlnt.lazierae2.util.GameUtil;
import dev.rlnt.lazierae2.util.IOUtil;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class ProcessorContainer<T extends ProcessorTile<?, ?>>
extends MachineContainer<T>
implements IInfo {
    private static final int PLAYER_INV_SIZE = 36;
    private final IIntArray info;

    protected ProcessorContainer(@Nullable ContainerType<?> type, int windowID, PlayerInventory playerInventory, T tile, IIntArray info) {
        super(type, windowID, playerInventory, tile);
        this.info = info;
        this.syncInfo();
    }

    @Override
    protected void initContainerInventory() {
        Object itemHandler = ((ProcessorTile)this.tile).getItemHandler();
        this.func_75146_a((Slot)new UpgradeSlot((IItemHandler)itemHandler, 0, 146, 62, (ProcessorTile)this.tile));
        if (itemHandler instanceof SingleItemHandler) {
            this.func_75146_a((Slot)new OutputSlot((IItemHandler)itemHandler, 1, 116, 35));
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, ((ProcessorTile)this.tile).getInputSlots()[0], 56, 35));
        } else {
            this.func_75146_a((Slot)new OutputSlot((IItemHandler)itemHandler, 1, 120, 35));
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return stack;
        }
        ItemStack slotStack = slot.func_75211_c();
        stack = slotStack.func_77946_l();
        if (((ProcessorTile)this.tile).isWithinProcessorSlots(index)) {
            if (!this.tryMergeToPlayerInventory(slotStack)) {
                return ItemStack.field_190927_a;
            }
        } else if (this.isValidForInput(slotStack)) {
            if (!this.tryMergeToInput(slotStack)) {
                return ItemStack.field_190927_a;
            }
        } else if (GameUtil.isUpgrade(slotStack)) {
            int mergeableUpgrades = this.getMergeableUpgrades();
            if (mergeableUpgrades > 0) {
                this.tryMergeToUpgrade(slotStack, mergeableUpgrades);
            } else {
                return ItemStack.field_190927_a;
            }
        }
        if (slotStack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (slotStack.func_190916_E() == stack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(playerIn, slotStack);
        return stack;
    }

    public boolean isValidForInput(ItemStack stack) {
        if (((ProcessorTile)this.tile).getItemHandler() instanceof SingleItemHandler) {
            return ((AbstractItemHandler)((Object)((ProcessorTile)this.tile).getItemHandler())).isItemValid(((ProcessorTile)this.tile).getInputSlots()[0], stack);
        }
        int[] nArray = ((ProcessorTile)this.tile).getInputSlots();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer slot = nArray[i];
            if (!((AbstractItemHandler)((Object)((ProcessorTile)this.tile).getItemHandler())).isItemValid(slot, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean tryMergeToInput(ItemStack stack) {
        if (((ProcessorTile)this.tile).getItemHandler() instanceof SingleItemHandler) {
            return this.func_75135_a(stack, ((ProcessorTile)this.tile).getInputSlots()[0], ((ProcessorTile)this.tile).getInputSlots()[0] + 1, false);
        }
        int validSlot = ((AbstractItemHandler)((Object)((ProcessorTile)this.tile).getItemHandler())).getValidSlot(stack);
        if (validSlot == -1) {
            return false;
        }
        return this.func_75135_a(stack, validSlot, validSlot + 1, false);
    }

    private int getMergeableUpgrades() {
        Object itemHandler = ((ProcessorTile)this.tile).getItemHandler();
        return ((AbstractItemHandler)((Object)itemHandler)).getSlotLimit(0) - itemHandler.getStackInSlot(0).func_190916_E();
    }

    private void tryMergeToUpgrade(ItemStack slotStack, int mergeableUpgrades) {
        if (slotStack.func_190916_E() > mergeableUpgrades) {
            ItemStack splitStack = slotStack.func_77946_l();
            splitStack.func_190920_e(mergeableUpgrades);
            slotStack.func_190918_g(mergeableUpgrades);
            this.func_75135_a(splitStack, 0, 1, false);
        } else {
            this.func_75135_a(slotStack, 0, 1, false);
        }
    }

    private boolean tryMergeToPlayerInventory(ItemStack stack) {
        return this.func_75135_a(stack, ((ProcessorTile)this.tile).func_70302_i_(), ((ProcessorTile)this.tile).func_70302_i_() + 36, false);
    }

    @Override
    public int getEnergyStored() {
        int upper = this.info.func_221476_a(1) & 0xFFFF;
        int lower = this.info.func_221476_a(0) & 0xFFFF;
        return (upper << 16) + lower;
    }

    @Override
    public int getEnergyCapacity() {
        int upper = this.info.func_221476_a(3) & 0xFFFF;
        int lower = this.info.func_221476_a(2) & 0xFFFF;
        return (upper << 16) + lower;
    }

    @Override
    public int getEffectiveEnergyConsumption() {
        return this.info.func_221476_a(4);
    }

    @Override
    public float getProgress() {
        return this.info.func_221476_a(5);
    }

    @Override
    public boolean isProcessing() {
        return this.getProgress() > 0.0f;
    }

    @Override
    public int getEffectiveProcessTime() {
        return this.info.func_221476_a(6);
    }

    @Override
    public EnumMap<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> getSideConfig() {
        return (EnumMap)IOUtil.getSideConfigFromArray(new int[]{this.info.func_221476_a(7), this.info.func_221476_a(8), this.info.func_221476_a(9), this.info.func_221476_a(10), this.info.func_221476_a(11), this.info.func_221476_a(12)});
    }

    @Override
    public boolean isAutoExtracting() {
        return this.info.func_221476_a(13) == 1;
    }

    @Override
    public void syncInfo() {
        this.func_216961_a(this.info);
    }
}

