/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.client.BookBakedModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BookLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().disableHtmlEscaping().create();
    private static final TypeToken<Map<String, String>> MACROS_TOKEN = new TypeToken<Map<String, String>>(){};
    private static final class_7654 BOOK_FINDER = class_7654.method_45114((String)"lavender/books");
    private static final Map<class_2960, Book> LOADED_BOOKS = new HashMap<class_2960, Book>();
    private static final Map<class_2960, Book> VISIBLE_BOOKS = new HashMap<class_2960, Book>();

    public static void initialize() {
        ModelLoadingPlugin.register(context -> {
            context.addModels(new class_2960[]{BookBakedModel.Unbaked.BROWN_BOOK_ID});
            for (Book book : VISIBLE_BOOKS.values()) {
                if (book.dynamicBookModel() == null) {
                    return;
                }
                context.addModels(new class_2960[]{new class_1091(book.dynamicBookModel(), "inventory")});
            }
        });
    }

    @Nullable
    public static Book get(class_2960 bookId) {
        return LOADED_BOOKS.get(bookId);
    }

    public static Collection<Book> loadedBooks() {
        return Collections.unmodifiableCollection(VISIBLE_BOOKS.values());
    }

    static Collection<Book> allBooks() {
        return Collections.unmodifiableCollection(LOADED_BOOKS.values());
    }

    public static void reload(class_3300 manager) {
        LOADED_BOOKS.clear();
        BOOK_FINDER.method_45113(manager).forEach((identifier, resource) -> {
            class_2960 openSoundId;
            JsonElement jsonElement;
            try (BufferedReader reader = resource.method_43039();){
                jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
            }
            catch (IOException e) {
                Lavender.LOGGER.warn("Could not load book '{}'", identifier, (Object)e);
                return;
            }
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject bookObject = jsonElement.getAsJsonObject();
            class_2960 resourceId = BOOK_FINDER.method_45115(identifier);
            class_2960 textureId = BookLoader.tryGetId(bookObject, "texture");
            class_2960 extendId = BookLoader.tryGetId(bookObject, "extend");
            class_2960 dynamicBookModelId = BookLoader.tryGetId(bookObject, "dynamic_book_model");
            class_5250 dynamicBookName = null;
            if (bookObject.has("dynamic_book_name")) {
                dynamicBookName = class_2561.class_2562.method_10872((JsonElement)bookObject.get("dynamic_book_name"));
            }
            class_3414 openSoundEvent = (openSoundId = BookLoader.tryGetId(bookObject, "open_sound")) != null ? (class_3414)class_7923.field_41172.method_10223(openSoundId) : null;
            class_2960 flippingSoundId = BookLoader.tryGetId(bookObject, "flipping_sound");
            class_3414 flippingSoundEvent = flippingSoundId != null ? (class_3414)class_7923.field_41172.method_10223(flippingSoundId) : null;
            class_2960 introEntryId = BookLoader.tryGetId(bookObject, "intro_entry");
            boolean displayCompletion = class_3518.method_15258((JsonObject)bookObject, (String)"display_completion", (boolean)false);
            boolean displayUnreadEntryNotifications = class_3518.method_15258((JsonObject)bookObject, (String)"display_unread_entry_notifications", (boolean)true);
            Map macros = (Map)GSON.fromJson((JsonElement)class_3518.method_15281((JsonObject)bookObject, (String)"macros", (JsonObject)new JsonObject()), MACROS_TOKEN);
            Book book = new Book(resourceId, extendId, textureId, dynamicBookModelId, (class_2561)dynamicBookName, openSoundEvent, flippingSoundEvent, introEntryId, displayUnreadEntryNotifications, displayCompletion, macros);
            LOADED_BOOKS.put(resourceId, book);
            if (extendId == null) {
                VISIBLE_BOOKS.put(resourceId, book);
            }
        });
        LOADED_BOOKS.values().removeIf(book -> {
            if (book.tryResolveExtension()) {
                return false;
            }
            Lavender.LOGGER.warn("Book '" + book.id() + "' (an extension) failed to load because its target was not found");
            return true;
        });
    }

    @Nullable
    private static class_2960 tryGetId(JsonObject json, String key) {
        String jsonString = class_3518.method_15253((JsonObject)json, (String)key, null);
        if (jsonString == null) {
            return null;
        }
        return class_2960.method_12829((String)jsonString);
    }
}

