/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.book.LavenderClientStorage;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Book {
    private static final Pattern MACRO_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    private static final Pattern MACRO_ARG_PATTERN = Pattern.compile("\\$\\d+");
    private final class_2960 id;
    @Nullable
    private final class_2960 texture;
    @Nullable
    private final class_2960 dynamicBookModel;
    @Nullable
    private final class_2561 dynamicBookName;
    private final class_3414 openSound;
    private final class_3414 flippingSound;
    @Nullable
    private final class_2960 introEntry;
    private final boolean displayUnreadEntryNotifications;
    private final boolean displayCompletion;
    private final Map<String, String> zeroArgMacros = new HashMap<String, String>();
    private final Map<Pattern, Macro> macros = new HashMap<Pattern, Macro>();
    @Nullable
    private final class_2960 extend;
    @Nullable
    private Book resolvedExtend = null;
    private final Map<class_2960, Category> categories = new HashMap<class_2960, Category>();
    private final Collection<Category> categoriesView = Collections.unmodifiableCollection(this.categories.values());
    private final Map<class_2960, Entry> entriesById = new HashMap<class_2960, Entry>();
    private final Collection<Entry> entriesView = Collections.unmodifiableCollection(this.entriesById.values());
    private final Map<Category, List<Entry>> entriesByCategory = new HashMap<Category, List<Entry>>();
    private final Multimap<class_1792, Entry> entriesByAssociatedItem = HashMultimap.create();
    private final List<Entry> orphanedEntries = new ArrayList<Entry>();
    private final Collection<Entry> orphanedEntriesView = Collections.unmodifiableCollection(this.orphanedEntries);
    @Nullable
    private Entry landingPage = null;

    public Book(class_2960 id, @Nullable class_2960 extend, @Nullable class_2960 texture, @Nullable class_2960 dynamicBookModel, @Nullable class_2561 dynamicBookName, @Nullable class_3414 openSound, @Nullable class_3414 flippingSound, @Nullable class_2960 introEntry, boolean displayUnreadEntryNotifications, boolean displayCompletion, Map<String, String> macros) {
        this.id = id;
        this.extend = extend;
        this.texture = texture;
        this.dynamicBookModel = dynamicBookModel;
        this.dynamicBookName = dynamicBookName;
        this.openSound = openSound != null ? openSound : Lavender.ITEM_BOOK_OPEN;
        this.flippingSound = flippingSound != null ? flippingSound : class_3417.field_17481;
        this.introEntry = introEntry;
        this.displayUnreadEntryNotifications = displayUnreadEntryNotifications;
        this.displayCompletion = displayCompletion;
        macros.forEach((macro, replacement) -> {
            int argCount = (int)MACRO_ARG_PATTERN.matcher((CharSequence)replacement).results().count();
            if (argCount > 0) {
                if (!MACRO_NAME_PATTERN.asPredicate().test((String)macro)) {
                    throw new JsonParseException("Parametrized macro '" + macro + "' contains invalid characters. Parametrized macro names must only contain '[a-zA-Z0-9_-]'");
                }
                ArrayList<String> parts = new ArrayList<String>();
                IntArrayList argIndices = new IntArrayList();
                StringBuilder result = new StringBuilder((String)replacement);
                Matcher argMatcher = MACRO_ARG_PATTERN.matcher(result);
                while (argMatcher.find()) {
                    parts.add(result.substring(0, argMatcher.start()));
                    argIndices.add(Integer.parseInt(argMatcher.group().substring(1)) - 1);
                    result.delete(0, argMatcher.end());
                    argMatcher.reset();
                }
                parts.add(result.toString());
                this.macros.put(Pattern.compile(Pattern.quote(macro) + "\\(" + Stream.generate(() -> "(.*)").limit(argCount).collect(Collectors.joining(",")) + "\\)"), new Macro(parts, (IntList)argIndices));
            } else {
                this.zeroArgMacros.put((String)macro, (String)replacement);
            }
        });
    }

    public class_2960 id() {
        return this.id;
    }

    public boolean displayCompletion() {
        return this.displayCompletion;
    }

    public boolean displayUnreadEntryNotifications() {
        return this.displayUnreadEntryNotifications;
    }

    public Collection<Entry> entries() {
        return this.entriesView;
    }

    public Collection<Entry> orphanedEntries() {
        return this.orphanedEntriesView;
    }

    @Nullable
    public Entry introEntry() {
        return this.introEntry != null ? this.entryById(this.introEntry) : null;
    }

    @Nullable
    public Entry entryById(class_2960 entryId) {
        return this.entriesById.get(entryId);
    }

    @Nullable
    public Entry entryByAssociatedItem(class_1799 associatedStack) {
        Collection candidates = this.entriesByAssociatedItem.get((Object)associatedStack.method_7909());
        for (Entry candidateEntry : candidates) {
            for (class_1799 candidateAssociatedStack : candidateEntry.associatedItems()) {
                if (candidateAssociatedStack.method_7909() != associatedStack.method_7909() || !class_2512.method_10687((class_2520)candidateAssociatedStack.method_7969(), (class_2520)associatedStack.method_7969(), (boolean)true)) continue;
                return candidateEntry;
            }
        }
        return null;
    }

    @Nullable
    public Collection<Entry> entriesByCategory(Category category) {
        List<Entry> entries = this.entriesByCategory.get(category);
        if (entries == null) {
            return null;
        }
        return Collections.unmodifiableCollection(entries);
    }

    @Nullable
    public Collection<Entry> descendantEntriesByCategory(Category category) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Category candidate : this.categories.values()) {
            Collection<Entry> possibleEntries;
            if (candidate != category && !Objects.equals(candidate.parent(), category.id()) || (possibleEntries = this.entriesByCategory(candidate)) == null) continue;
            entries.addAll(possibleEntries);
        }
        if (entries.isEmpty()) {
            return null;
        }
        return entries;
    }

    public Collection<Category> categories() {
        return this.categoriesView;
    }

    @Nullable
    public Category categoryById(class_2960 categoryId) {
        return this.categories.get(categoryId);
    }

    public boolean shouldDisplayCategory(Category category, class_746 player) {
        Collection<Entry> entries = this.descendantEntriesByCategory(category);
        if (entries == null) {
            return false;
        }
        boolean anyVisible = false;
        for (Entry entry : entries) {
            if (!entry.canPlayerView(player)) continue;
            anyVisible = true;
        }
        return anyVisible;
    }

    public boolean shouldDisplayUnreadNotification(Entry entry) {
        return this.displayUnreadEntryNotifications && !LavenderClientStorage.wasEntryViewed(this, entry);
    }

    public boolean shouldDisplayUnreadNotification(Category category, class_746 player) {
        if (!this.displayUnreadEntryNotifications) {
            return false;
        }
        Collection<Entry> entries = this.descendantEntriesByCategory(category);
        if (entries == null) {
            return false;
        }
        for (Entry entry : entries) {
            if (!entry.canPlayerView(player) || LavenderClientStorage.wasEntryViewed(this, entry)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Entry landingPage() {
        return this.landingPage;
    }

    @Nullable
    public class_2960 texture() {
        return this.texture;
    }

    @Nullable
    public class_2960 dynamicBookModel() {
        return this.dynamicBookModel;
    }

    @Nullable
    public class_2561 dynamicBookName() {
        return this.dynamicBookName;
    }

    public class_3414 openSound() {
        return this.openSound;
    }

    public class_3414 flippingSound() {
        return this.flippingSound;
    }

    public int countVisibleEntries(class_746 player) {
        int visible = 0;
        for (Entry entry : this.entriesById.values()) {
            if (!entry.canPlayerView(player)) continue;
            ++visible;
        }
        return visible;
    }

    String expandMacros(class_2960 entry, String input) {
        StringBuilder builder = new StringBuilder(input);
        int scans = 0;
        boolean anyExpansions = true;
        while (scans < 1000 && anyExpansions) {
            anyExpansions = false;
            for (String string : this.zeroArgMacros.keySet()) {
                int replaceIndex = builder.indexOf(string);
                while (replaceIndex != -1) {
                    String replacement = this.zeroArgMacros.get(string);
                    anyExpansions = true;
                    builder.replace(replaceIndex, replaceIndex + string.length(), replacement);
                    replaceIndex = builder.indexOf(string, replaceIndex + replacement.length());
                }
            }
            for (Pattern pattern : this.macros.keySet()) {
                Macro replacement = this.macros.get(pattern);
                Matcher matcher = pattern.matcher(builder);
                while (scans < 1000 && matcher.find()) {
                    ++scans;
                    anyExpansions = true;
                    ArrayList<String> args = new ArrayList<String>();
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        args.add(matcher.group(i));
                    }
                    builder.replace(matcher.start(), matcher.end(), replacement.apply(args));
                    matcher.reset();
                }
            }
        }
        if (scans >= 1000) {
            Lavender.LOGGER.warn("Preprocessing of entry {} in book {} failed: Macro expansion proceeded for over 1000 scans, a circular macro invocation is likely", (Object)entry, (Object)this.id);
            return "{red}**Entry processing failed:**{}\n\n\nMacro expansion proceeded for over 1000 scans without reaching\na result - this is almost definitely due to a circular macro invocation\n";
        }
        return builder.toString();
    }

    void setLandingPage(@NotNull Entry landingPage) {
        this.landingPage = landingPage;
    }

    void addEntry(Entry entry) {
        if (this.resolvedExtend != null) {
            this.resolvedExtend.addEntry(entry);
        } else {
            this.entriesById.put(entry.id(), entry);
            entry.associatedItems().forEach(stack -> this.entriesByAssociatedItem.put((Object)stack.method_7909(), (Object)entry));
            if (this.categories.containsKey(entry.category())) {
                this.entriesByCategory.computeIfAbsent(this.categories.get(entry.category()), $ -> new ArrayList()).add(entry);
            } else if (entry.category() == null) {
                this.orphanedEntries.add(entry);
            } else {
                throw new RuntimeException("Could not load entry '" + entry.id() + "' because category '" + entry.category() + "' was not found in book '" + this.effectiveId() + "'");
            }
        }
    }

    void addCategory(Category category) {
        if (this.resolvedExtend != null) {
            this.resolvedExtend.addCategory(category);
        } else {
            this.categories.put(category.id(), category);
        }
    }

    boolean tryResolveExtension() {
        if (this.extend == null) {
            return true;
        }
        this.resolvedExtend = BookLoader.get(this.extend);
        return this.resolvedExtend != null;
    }

    class_2960 effectiveId() {
        return this.resolvedExtend != null ? this.resolvedExtend.effectiveId() : this.id;
    }

    public record Macro(List<String> parts, IntList argIndices) {
        String apply(List<String> args) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.argIndices.size(); ++i) {
                result.append(this.parts.get(i));
                int argIndex = this.argIndices.getInt(i);
                result.append(argIndex - 1 < args.size() ? args.get(i) : "");
            }
            result.append(this.parts.get(this.parts.size() - 1));
            return result.toString();
        }
    }

    public static interface BookmarkableElement {
        public String title();

        public Function<Sizing, Component> iconFactory();
    }
}

