/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server.tag;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.server.tag.EmptyTagTargetException;
import dev.latvian.mods.kubejs.server.tag.TagEventJS;
import dev.latvian.mods.kubejs.server.tag.TagWrapper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_5699;

public interface TagEventFilter {
    public static TagEventFilter of(TagEventJS event, Object o) {
        if (o instanceof TagEventFilter) {
            TagEventFilter f2 = (TagEventFilter)o;
            return f2;
        }
        if (o instanceof Collection) {
            Collection list = (Collection)o;
            List<TagEventFilter> filters = list.stream().map(o1 -> TagEventFilter.of(event, o1)).flatMap(TagEventFilter::unwrap).filter(f -> f != Empty.INSTANCE).toList();
            return filters.isEmpty() ? Empty.INSTANCE : (filters.size() == 1 ? filters.get(0) : new Or(filters));
        }
        Pattern regex = UtilsJS.parseRegex(o);
        if (regex != null) {
            return new RegEx(regex);
        }
        String s = o.toString().trim();
        if (!s.isEmpty()) {
            return switch (s.charAt(0)) {
                case '#' -> new Tag(event.get(new class_2960(s.substring(1))));
                case '@' -> new Namespace(s.substring(1));
                default -> new ID(new class_2960(s));
            };
        }
        return Empty.INSTANCE;
    }

    public static TagEventFilter unwrap(TagEventJS event, Object[] array) {
        TagEventFilter filter = array.length == 1 ? TagEventFilter.of(event, array[0]) : TagEventFilter.of(event, Arrays.asList(array));
        return filter;
    }

    public boolean testElementId(class_2960 var1);

    default public boolean testTagOrElementLocation(class_5699.class_7476 element) {
        return !element.comp_814() && this.testElementId(element.comp_813());
    }

    default public Stream<TagEventFilter> unwrap() {
        return Stream.of(this);
    }

    default public int add(TagWrapper wrapper) {
        int count = 0;
        for (class_2960 id : wrapper.event.getElementIds()) {
            if (!this.testElementId(id)) continue;
            wrapper.entries.add(new class_3503.class_5145(class_3497.method_43937((class_2960)id), "KubeJS Custom Tags"));
            ++count;
        }
        return count;
    }

    default public int remove(TagWrapper wrapper) {
        int count = 0;
        Iterator<class_3503.class_5145> itr = wrapper.entries.iterator();
        while (itr.hasNext()) {
            class_3503.class_5145 it = itr.next();
            if (it.comp_324().field_39267 || !this.testElementId(it.comp_324().field_15584)) continue;
            itr.remove();
            ++count;
        }
        return count;
    }

    public static class Empty
    implements TagEventFilter {
        public static final Empty INSTANCE = new Empty();

        @Override
        public boolean testElementId(class_2960 resourceLocation) {
            return false;
        }

        @Override
        public boolean testTagOrElementLocation(class_5699.class_7476 element) {
            return false;
        }

        @Override
        public int add(TagWrapper wrapper) {
            return 0;
        }

        @Override
        public int remove(TagWrapper wrapper) {
            return 0;
        }
    }

    public record Or(List<TagEventFilter> filters) implements TagEventFilter
    {
        @Override
        public boolean testElementId(class_2960 resourceLocation) {
            for (TagEventFilter filter : this.filters) {
                if (!filter.testElementId(resourceLocation)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testTagOrElementLocation(class_5699.class_7476 element) {
            for (TagEventFilter filter : this.filters) {
                if (!filter.testTagOrElementLocation(element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Stream<TagEventFilter> unwrap() {
            return this.filters.stream();
        }

        @Override
        public int add(TagWrapper wrapper) {
            int count = 0;
            for (TagEventFilter filter : this.filters) {
                count += filter.add(wrapper);
            }
            return count;
        }

        @Override
        public int remove(TagWrapper wrapper) {
            int count = 0;
            for (TagEventFilter filter : this.filters) {
                count += filter.remove(wrapper);
            }
            return count;
        }
    }

    public record RegEx(Pattern pattern) implements TagEventFilter
    {
        @Override
        public boolean testElementId(class_2960 id) {
            return this.pattern.matcher(id.toString()).find();
        }
    }

    public record Tag(TagWrapper tag) implements TagEventFilter
    {
        @Override
        public boolean testElementId(class_2960 id) {
            return false;
        }

        @Override
        public boolean testTagOrElementLocation(class_5699.class_7476 element) {
            return element.comp_814() && this.tag.id.equals((Object)element.comp_813());
        }

        @Override
        public int add(TagWrapper wrapper) {
            wrapper.entries.add(new class_3503.class_5145(class_3497.method_43945((class_2960)this.tag.id), "KubeJS Custom Tags"));
            return 1;
        }

        @Override
        public int remove(TagWrapper wrapper) {
            int count = 0;
            Iterator<class_3503.class_5145> itr = wrapper.entries.iterator();
            while (itr.hasNext()) {
                class_3503.class_5145 it = itr.next();
                if (!it.comp_324().field_39267 || !it.comp_324().field_15584.equals((Object)this.tag.id)) continue;
                itr.remove();
                ++count;
            }
            return count;
        }
    }

    public record Namespace(String namespace) implements TagEventFilter
    {
        @Override
        public boolean testElementId(class_2960 id) {
            return id.method_12836().equals(this.namespace);
        }
    }

    public record ID(class_2960 id) implements TagEventFilter
    {
        @Override
        public boolean testElementId(class_2960 id) {
            return this.id.equals((Object)id);
        }

        @Override
        public int add(TagWrapper wrapper) {
            if (wrapper.event.getElementIds().contains(this.id)) {
                wrapper.entries.add(new class_3503.class_5145(class_3497.method_43937((class_2960)this.id), "KubeJS Custom Tags"));
                return 1;
            }
            String msg = "No such element %s in registry %s".formatted(this.id, wrapper.event.registry);
            if (DevProperties.get().strictTags) {
                throw new EmptyTagTargetException(msg);
            }
            if (DevProperties.get().logSkippedTags) {
                ConsoleJS.SERVER.warn(msg);
            }
            return 0;
        }
    }
}

