/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.core.RecipeKJS;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.recipe.filter.ConstantFilter;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public class AfterRecipesLoadedEventJS
extends EventJS {
    private final Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipeMap;
    private final Map<class_2960, class_1860<?>> recipeIdMap;
    private List<RecipeKJS> originalRecipes;

    public AfterRecipesLoadedEventJS(Map<class_3956<?>, Map<class_2960, class_1860<?>>> r, Map<class_2960, class_1860<?>> n) {
        this.recipeMap = r;
        this.recipeIdMap = n;
    }

    private List<RecipeKJS> getOriginalRecipes() {
        if (this.originalRecipes == null) {
            this.originalRecipes = new ArrayList<RecipeKJS>();
            for (Map<class_2960, class_1860<?>> map : this.recipeMap.values()) {
                for (Map.Entry<class_2960, class_1860<?>> entry : map.entrySet()) {
                    this.originalRecipes.add((RecipeKJS)entry.getValue());
                }
            }
        }
        return this.originalRecipes;
    }

    public void forEachRecipe(RecipeFilter filter, Consumer<RecipeKJS> consumer) {
        if (filter == ConstantFilter.TRUE) {
            this.getOriginalRecipes().forEach(consumer);
        } else if (filter != ConstantFilter.FALSE) {
            this.getOriginalRecipes().stream().filter(filter).forEach(consumer);
        }
    }

    public int countRecipes(RecipeFilter filter) {
        if (filter == ConstantFilter.TRUE) {
            return this.getOriginalRecipes().size();
        }
        if (filter != ConstantFilter.FALSE) {
            return (int)this.getOriginalRecipes().stream().filter(filter).count();
        }
        return 0;
    }

    public int remove(RecipeFilter filter) {
        int count = 0;
        Iterator<RecipeKJS> itr = this.getOriginalRecipes().iterator();
        while (itr.hasNext()) {
            RecipeKJS r = itr.next();
            if (!filter.test(r)) continue;
            Map<class_2960, class_1860<?>> map = this.recipeMap.get(((class_1860)r).method_17716());
            if (map != null) {
                map.remove(r.kjs$getOrCreateId());
            }
            this.recipeIdMap.remove(r.kjs$getOrCreateId());
            itr.remove();
            ++count;
            if (DevProperties.get().logRemovedRecipes) {
                ConsoleJS.SERVER.info("- " + r);
                continue;
            }
            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
            ConsoleJS.SERVER.debug("- " + r);
        }
        return count;
    }

    @Override
    protected void afterPosted(EventResult isCanceled) {
        this.recipeMap.values().removeIf(Map::isEmpty);
    }
}

