/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.platform.fabric.ingredient;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.platform.fabric.ingredient.KubeJSIngredient;
import dev.latvian.mods.kubejs.platform.fabric.ingredient.KubeJSIngredientSerializer;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class RegExIngredient
extends KubeJSIngredient {
    public static final KubeJSIngredientSerializer<RegExIngredient> SERIALIZER = new KubeJSIngredientSerializer<RegExIngredient>(KubeJS.id("regex"), RegExIngredient::new, RegExIngredient::new);
    public final Pattern pattern;

    public RegExIngredient(Pattern pattern) {
        this.pattern = pattern;
    }

    public RegExIngredient(class_2540 buf) {
        this(Pattern.compile(buf.method_19772(), buf.method_10816()));
    }

    public RegExIngredient(JsonObject json) {
        this(UtilsJS.parseRegex(json.get("pattern").getAsString()));
    }

    public boolean test(@Nullable class_1799 stack) {
        return stack != null && this.pattern.matcher(stack.kjs$getId()).find();
    }

    public List<class_1799> getMatchingStacks() {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (class_1792 item : RegistryInfo.ITEM.getArchitecturyRegistrar()) {
            if (!this.pattern.matcher(item.kjs$getId()).find()) continue;
            list.add(item.method_7854());
        }
        return list;
    }

    @Override
    public KubeJSIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public void toJson(JsonObject json) {
        json.addProperty("regex", this.pattern.toString());
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10814(this.pattern.toString());
        buf.method_10804(this.pattern.flags());
    }
}

