/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.gui.chest;

import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.gui.chest.ChestMenuClickCallback;
import dev.latvian.mods.kubejs.gui.chest.ChestMenuClickHandler;
import dev.latvian.mods.kubejs.gui.chest.ChestMenuData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1713;
import net.minecraft.class_1799;

public class ChestMenuSlot {
    public final ChestMenuData gui;
    public final int index;
    public final int x;
    public final int y;
    private class_1799 item;
    public int clicked;
    public Map<String, Object> data;
    public final List<ChestMenuClickHandler> clickHandlers;
    public InventoryKJS inventory;
    public int inventorySlot;

    public ChestMenuSlot(ChestMenuData gui, int index) {
        this.gui = gui;
        this.index = index;
        this.x = index % 9;
        this.y = index / 9;
        this.item = class_1799.field_8037;
        this.clicked = 0;
        this.data = new HashMap<String, Object>();
        this.clickHandlers = new ArrayList<ChestMenuClickHandler>(1);
        this.inventory = null;
        this.inventorySlot = -1;
    }

    public String toString() {
        return "Slot[" + this.x + "," + this.y + "]";
    }

    public void setItem(class_1799 stack) {
        if (this.inventory != null && this.inventorySlot >= 0) {
            this.inventory.kjs$setStackInSlot(this.inventorySlot, stack);
        } else {
            this.item = stack;
        }
    }

    public class_1799 getItem() {
        if (this.inventory != null && this.inventorySlot >= 0) {
            return this.inventory.kjs$getStackInSlot(this.inventorySlot);
        }
        return this.item;
    }

    public void resetClickHandlers() {
        this.clickHandlers.clear();
    }

    public void clicked(class_1713 type, int button, ChestMenuClickCallback callback, boolean autoHandle) {
        this.clickHandlers.add(new ChestMenuClickHandler(type, button, callback, autoHandle));
    }

    public void setLeftClicked(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7790, 0, callback, true);
    }

    public void setRightClicked(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7790, 1, callback, true);
    }

    public void setMiddleClicked(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7796, 2, callback, true);
    }

    public void setSwapped(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7791, -1, callback, true);
    }

    public void setThrown(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7795, -1, callback, true);
    }

    public void setShiftLeftClicked(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7794, 0, callback, true);
    }

    public void setShiftRightClicked(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7794, 1, callback, true);
    }

    public void setDoubleClicked(ChestMenuClickCallback callback) {
        this.clicked(class_1713.field_7793, -1, callback, true);
    }
}

