/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism;

import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.mekanism.MekanismRecipeJS;
import dev.latvian.kubejs.util.ListJS;

public class SawingRecipeJS
extends MekanismRecipeJS {
    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)).asIngredientStack());
        if (args.size() >= 3) {
            this.outputItems.add(this.parseResultItem(args.get(2)));
        }
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("mainOutput")));
        this.inputItems.add(this.parseIngredientItem(this.json.get("input")).asIngredientStack());
        if (this.json.has("secondaryOutput")) {
            ItemStackJS stackJS = this.parseResultItem(this.json.get("secondaryOutput"));
            if (this.json.has("secondaryChance")) {
                stackJS.setChance(this.json.get("secondaryChance").getAsDouble());
            }
            this.outputItems.add(stackJS);
        }
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("mainOutput", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
            if (this.outputItems.size() >= 2) {
                ItemStackJS stackJS = ((ItemStackJS)this.outputItems.get(1)).copy();
                double c = stackJS.getChance();
                stackJS.setChance(-1.0);
                this.json.add("secondaryOutput", stackJS.toResultJson());
                this.json.addProperty("secondaryChance", (Number)c);
            }
        }
        if (this.serializeInputs) {
            this.json.add("input", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
    }
}

