/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.create;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingRecipeJS
extends RecipeJS {
    public final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
    public final List<FluidStack> outputFluids = new ArrayList<FluidStack>();

    public void create(ListJS args) {
        CompoundNBT nbt;
        for (Object o : ListJS.orSelf((Object)args.get(0))) {
            if (o instanceof FluidStackJS) {
                nbt = new CompoundNBT();
                ((FluidStackJS)o).getFluidStack().write(nbt);
                this.outputFluids.add(FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt));
                continue;
            }
            this.outputItems.add(this.parseResultItem(o));
        }
        for (Object o : ListJS.orSelf((Object)args.get(1))) {
            if (o instanceof FluidStackJS) {
                nbt = new CompoundNBT();
                ((FluidStackJS)o).getFluidStack().write(nbt);
                this.inputFluids.add(FluidIngredient.fromFluidStack((FluidStack)FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt)));
                continue;
            }
            if (o instanceof MapJS && (((MapJS)o).containsKey((Object)"fluid") || ((MapJS)o).containsKey((Object)"fluidTag"))) {
                this.inputFluids.add(FluidIngredient.deserialize((JsonElement)((MapJS)o).toJson()));
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(o));
        }
        this.json.addProperty("processingTime", (Number)100);
    }

    public void deserialize() {
        for (JsonElement e : this.json.get("ingredients").getAsJsonArray()) {
            if (FluidIngredient.isFluidIngredient((JsonElement)e)) {
                this.inputFluids.add(FluidIngredient.deserialize((JsonElement)e));
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(e));
        }
        for (JsonElement e : this.json.get("results").getAsJsonArray()) {
            JsonObject jsonObject = e.getAsJsonObject();
            if (jsonObject.has("fluid")) {
                this.outputFluids.add(FluidHelper.deserializeFluidStack((JsonObject)jsonObject));
                continue;
            }
            this.outputItems.add(this.parseResultItem(e));
        }
    }

    public ProcessingRecipeJS processingTime(int t) {
        this.json.addProperty("processingTime", (Number)t);
        this.save();
        return this;
    }

    public ProcessingRecipeJS heatRequirement(String req) {
        this.json.addProperty("heatRequirement", req);
        this.save();
        return this;
    }

    public ProcessingRecipeJS heated() {
        return this.heatRequirement("heated");
    }

    public ProcessingRecipeJS superheated() {
        return this.heatRequirement("superheated");
    }

    public void serialize() {
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        for (IngredientJS ingredientJS : this.inputItems) {
            for (IngredientJS in1 : ingredientJS.unwrapStackIngredient()) {
                jsonIngredients.add(in1.toJson());
            }
        }
        for (FluidIngredient fluidIngredient : this.inputFluids) {
            jsonIngredients.add((JsonElement)fluidIngredient.serialize());
        }
        for (ItemStackJS itemStackJS : this.outputItems) {
            jsonOutputs.add(itemStackJS.toResultJson());
        }
        for (FluidStack fluidStack : this.outputFluids) {
            jsonOutputs.add(FluidHelper.serializeFluidStack((FluidStack)fluidStack));
        }
        this.json.add("ingredients", (JsonElement)jsonIngredients);
        this.json.add("results", (JsonElement)jsonOutputs);
    }
}

