/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.HashSet;
import java.util.Set;
import jeresources.entry.EnchantmentEntry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentRegistry {
    private Set<EnchantmentEntry> enchantments = new HashSet<EnchantmentEntry>();
    private static EnchantmentRegistry instance;

    public static EnchantmentRegistry getInstance() {
        if (instance == null) {
            instance = new EnchantmentRegistry();
            return instance;
        }
        return instance;
    }

    public EnchantmentRegistry() {
        for (Enchantment enchantment : EnchantmentRegistry.getEnchants()) {
            if (enchantment == null) continue;
            this.enchantments.add(new EnchantmentEntry(enchantment));
        }
    }

    public Set<EnchantmentEntry> getEnchantments(ItemStack itemStack) {
        HashSet<EnchantmentEntry> set = new HashSet<EnchantmentEntry>();
        for (EnchantmentEntry enchantment : this.enchantments) {
            if (itemStack.func_77973_b() == Items.field_151122_aG && enchantment.getEnchantment().isAllowedOnBooks()) {
                set.add(enchantment);
                continue;
            }
            if (!enchantment.getEnchantment().func_92089_a(itemStack)) continue;
            set.add(enchantment);
        }
        return set;
    }

    private void excludeFormRegistry(Enchantment enchantment) {
        this.enchantments.removeIf(enchantmentEntry -> enchantmentEntry.getEnchantment().getRegistryName().toString().equals(enchantment.getRegistryName().toString()));
    }

    private void excludeFormRegistry(String sEnchantment) {
        for (Enchantment enchantment : EnchantmentRegistry.getEnchants()) {
            if (enchantment == null || !enchantment.getRegistryName().toString().toLowerCase().contains(sEnchantment.toLowerCase())) continue;
            this.excludeFormRegistry(enchantment);
        }
    }

    public void removeAll(String[] excludedEnchants) {
        for (String enchant : excludedEnchants) {
            this.excludeFormRegistry(enchant);
        }
    }

    private static Iterable<Enchantment> getEnchants() {
        return ForgeRegistries.ENCHANTMENTS;
    }
}

