/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.distributions;

import java.util.Collections;
import java.util.TreeSet;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;

public class DistributionHelpers {
    public static final float PI = (float)Math.PI;

    public static float[] getTriangularDistribution(int midY, int range, float maxChance) {
        return DistributionHelpers.getTriangularDistribution(midY - range, range, range, maxChance);
    }

    public static float[] getTriangularDistribution(int minY, int rand1, int rand2, float maxChance) {
        float[] triangle = new float[rand1 + rand2 + 1];
        float modChance = maxChance / (float)Math.min(rand1, rand2);
        for (int i = 0; i < rand1; ++i) {
            for (int j = 0; j < rand2; ++j) {
                int n = i + j;
                triangle[n] = triangle[n] + modChance;
            }
        }
        float[] result = new float[256];
        for (int i = 0; i < triangle.length; ++i) {
            int mapToPos = i + minY;
            if (mapToPos < 0) continue;
            if (mapToPos == result.length) break;
            result[mapToPos] = triangle[i];
        }
        return result;
    }

    public static float[] getSquareDistribution(int minY, int maxY, float chance) {
        float[] result = new float[256];
        for (int i = minY; i <= maxY; ++i) {
            result[i] = chance;
        }
        return result;
    }

    public static float[] getRoundedSquareDistribution(int min0, int minY, int maxY, int max0, float chance) {
        float[] result = new float[256];
        DistributionHelpers.addDistribution(result, DistributionHelpers.getRampDistribution(min0, minY, chance), min0);
        DistributionHelpers.addDistribution(result, DistributionHelpers.getSquareDistribution(minY, maxY, chance));
        DistributionHelpers.addDistribution(result, DistributionHelpers.getRampDistribution(max0, maxY, chance), maxY);
        return result;
    }

    public static float[] getUnderwaterDistribution(float chance) {
        float[] result = DistributionHelpers.getTriangularDistribution(47, 8, chance / 7.0f);
        DistributionHelpers.addDistribution(result, DistributionHelpers.getRampDistribution(57, 62, chance), 57);
        result[62] = chance;
        DistributionHelpers.addDistribution(result, DistributionHelpers.getTriangularDistribution(55, 4, chance / 3.0f));
        return result;
    }

    public static float[] getRampDistribution(int minY, int maxY, float minChance, float maxChance) {
        if (minY == maxY) {
            return new float[0];
        }
        if (minY > maxY) {
            return DistributionHelpers.reverse(DistributionHelpers.getRampDistribution(maxY, minY, minChance, maxChance));
        }
        int range = maxY - minY;
        float chanceDiff = maxChance - minChance;
        float[] result = new float[range + 1];
        for (int i = 0; i < range; ++i) {
            result[i] = minChance + chanceDiff * (float)i / (float)range;
        }
        return result;
    }

    public static float[] getRampDistribution(int minY, int maxY, float maxChance) {
        return DistributionHelpers.getRampDistribution(minY, maxY, 0.0f, maxChance);
    }

    public static float[] getOverworldSurfaceDistribution(int oreDiameter) {
        float[] result = new float[256];
        float[] triangularDist = DistributionHelpers.getOverworldSurface();
        float chance = (float)oreDiameter / 256.0f;
        for (int i = 0; i < result.length - oreDiameter && i != triangularDist.length; ++i) {
            if (triangularDist[i] == 0.0f) continue;
            for (int j = 0; j < oreDiameter; ++j) {
                int n = i + j;
                result[n] = result[n] + triangularDist[i] * chance;
            }
        }
        return result;
    }

    public static float[] getOverworldSurface() {
        return DistributionHelpers.getTriangularDistribution(69, 5, 0.09090909f);
    }

    public static float[] addDistribution(float[] base, float[] add) {
        return DistributionHelpers.addDistribution(base, add, 0);
    }

    public static DistributionBase addDistribution(DistributionBase base, DistributionBase add) {
        return new DistributionCustom(DistributionHelpers.addDistribution(base.getDistribution(), add.getDistribution()));
    }

    public static float[] addDistribution(float[] base, float[] add, int offset) {
        int addCount = 0;
        int i = offset;
        while (i < Math.min(base.length, add.length + offset)) {
            int n = i++;
            base[n] = base[n] + add[addCount++];
        }
        return base;
    }

    public static float[] reverse(float[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[array.length - 1 - i] = array[i];
        }
        return result;
    }

    @Deprecated
    public static int calculateMeanLevel(float[] distribution, int mid, int oldMid, float difference) {
        return DistributionHelpers.calculateMeanLevel(distribution, mid);
    }

    public static int calculateMeanLevel(float[] distribution, int mid) {
        int i;
        float adjacent = 0.0f;
        float maxAdjacent = 0.0f;
        int consecutive = 0;
        mid = 0;
        for (i = 0; i < 4 && i < distribution.length; ++i) {
            adjacent += distribution[i];
        }
        for (i = 0; i < distribution.length - 4; ++i) {
            if ((adjacent -= distribution[i] - distribution[i + 4]) > maxAdjacent) {
                mid = i + 2;
                maxAdjacent = adjacent + 1.0E-5f;
                consecutive = 0;
                continue;
            }
            if (adjacent > maxAdjacent - 2.0E-5f) {
                ++consecutive;
                continue;
            }
            mid += consecutive / 2;
            consecutive = 0;
        }
        return mid;
    }

    public static float[] divideArray(float[] array, float num) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] / num;
        }
        return result;
    }

    public static float[] multiplyArray(float[] array, float num) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * num;
        }
        return result;
    }

    public static float[] maxJoinArray(float[] array1, float[] array2) {
        float[] result = new float[array1.length];
        if (array1.length != array2.length) {
            return result;
        }
        for (int i = 0; i < array1.length; ++i) {
            result[i] = Math.max(array1[i], array2[i]);
        }
        return result;
    }

    public static float sum(float[] distribution) {
        float result = 0.0f;
        for (float val : distribution) {
            result += val;
        }
        return result;
    }

    public static float calculateChance(int veinCount, int veinSize, int minY, int maxY) {
        return (float)veinCount * (float)veinSize / (float)((maxY - minY + 1) * 256);
    }

    public static float[] getDistributionFromPoints(OrePoint ... points) {
        TreeSet set = new TreeSet();
        Collections.addAll(set, points);
        points = set.toArray(new OrePoint[set.size()]);
        float[] array = new float[256];
        DistributionHelpers.addDistribution(array, DistributionHelpers.getRampDistribution(0, points[0].level, points[0].chance));
        for (int i = 1; i < points.length; ++i) {
            OrePoint max;
            OrePoint min;
            if (points[i - 1].chance <= points[i].chance) {
                min = points[i - 1];
                max = points[i];
            } else {
                max = points[i - 1];
                min = points[i];
            }
            float[] ramp = DistributionHelpers.getRampDistribution(min.level, max.level, min.chance, max.chance);
            DistributionHelpers.addDistribution(array, ramp, points[i - 1].level);
            array[((OrePoint)points[i - 1]).level] = points[i - 1].chance;
            array[((OrePoint)points[i]).level] = points[i].chance;
        }
        return array;
    }

    public static class OrePoint
    implements Comparable<OrePoint> {
        private final int level;
        private final float chance;

        public OrePoint(int level, float chance) {
            this.level = level;
            this.chance = chance;
        }

        @Override
        public int compareTo(OrePoint o) {
            return this.level - o.level;
        }
    }
}

