/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public abstract class WTooltip
implements IWidget {
    public String name;
    protected Utilities.Timer timer = new Utilities.Timer();

    public WTooltip(@Nullable String name) {
        this.name = name;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        if (this.name != null) {
            this.timer.setState(this.mouseIn(xMouse, yMouse));
        }
        return false;
    }

    @Override
    public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
        List suffix;
        String str;
        if (this.timer.getTime() > 500L && (str = (String)(suffix = this.getSuffix().stream().map(s -> Utilities.I18n.search(s.isEmpty() ? String.join((CharSequence)".", "gui", this.name) : String.join((CharSequence)".", "gui", this.name, s), new Object[0])).collect(Collectors.toList())).stream().filter(p -> (Boolean)p.two).findFirst().map(p -> (String)p.one).orElse(null)) != null) {
            Collections.addAll(tooltip, str.split("\n"));
        }
        return false;
    }

    protected List<String> getSuffix() {
        return Collections.singletonList("");
    }

    public abstract boolean mouseIn(int var1, int var2);
}

