/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.structure.RecordMath;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WLcd
implements IWidget {
    static HashMap<Character, boolean[]> PATTERN = new HashMap();
    public int yPos;
    public String text = "";
    public int dot = -1;
    static NumberFormat format = new DecimalFormat("0.0E0");
    public RecordMath.Operator operator = RecordMath.Operator.EQUALS;

    public WLcd(int yPos) {
        this.yPos = yPos;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        this.drawBackground(gui);
        this.drawStr(gui, this.text);
        if (this.dot != -1) {
            this.drawDot(gui, 6 - this.dot);
        }
        this.drawOperator(gui, this.operator);
        return false;
    }

    protected void drawBackground(JecaGui gui) {
        gui.drawResourceContinuous(Resource.WGT_LCD_BG, 7, this.yPos, 162, 50, 8);
        for (int i = 0; i < 7; ++i) {
            gui.drawResource(Resource.WGT_LCD_UL_N, 16 + i * 21, this.yPos + 14);
            gui.drawResource(Resource.WGT_LCD_UR_N, 30 + i * 21, this.yPos + 14);
            gui.drawResource(Resource.WGT_LCD_LL_N, 16 + i * 21, this.yPos + 28);
            gui.drawResource(Resource.WGT_LCD_LR_N, 30 + i * 21, this.yPos + 28);
            gui.drawResource(Resource.WGT_LCD_H_N, 19 + i * 21, this.yPos + 14);
            gui.drawResource(Resource.WGT_LCD_H_N, 19 + i * 21, this.yPos + 27);
            gui.drawResource(Resource.WGT_LCD_H_N, 19 + i * 21, this.yPos + 40);
            gui.drawResource(Resource.WGT_LCD_DO_N, 33 + i * 21, this.yPos + 40);
        }
        gui.drawResource(Resource.WGT_LCD_P_N, 132, this.yPos + 6);
        gui.drawResource(Resource.WGT_LCD_M_N, 139, this.yPos + 6);
        gui.drawResource(Resource.WGT_LCD_T_N, 146, this.yPos + 6);
        gui.drawResource(Resource.WGT_LCD_D_N, 153, this.yPos + 6);
    }

    protected void drawChar(JecaGui gui, char ch, int index) {
        boolean[] pattern = PATTERN.get(Character.valueOf(ch));
        Objects.requireNonNull(pattern, "Unsupported char: " + ch + ".");
        if (pattern[0]) {
            gui.drawResource(Resource.WGT_LCD_H_F, 19 + index * 21, this.yPos + 14);
        }
        if (pattern[1]) {
            gui.drawResource(Resource.WGT_LCD_UR_F, 30 + index * 21, this.yPos + 14);
        }
        if (pattern[2]) {
            gui.drawResource(Resource.WGT_LCD_LR_F, 30 + index * 21, this.yPos + 28);
        }
        if (pattern[3]) {
            gui.drawResource(Resource.WGT_LCD_H_F, 19 + index * 21, this.yPos + 40);
        }
        if (pattern[4]) {
            gui.drawResource(Resource.WGT_LCD_LL_F, 16 + index * 21, this.yPos + 28);
        }
        if (pattern[5]) {
            gui.drawResource(Resource.WGT_LCD_UL_F, 16 + index * 21, this.yPos + 14);
        }
        if (pattern[6]) {
            gui.drawResource(Resource.WGT_LCD_H_F, 19 + index * 21, this.yPos + 27);
        }
    }

    protected void drawStr(JecaGui gui, String str) {
        int offset;
        for (int i = offset = 7 - str.length(); i < 7; ++i) {
            this.drawChar(gui, str.charAt(i - offset), i);
        }
    }

    protected void drawDot(JecaGui gui, int index) {
        gui.drawResource(Resource.WGT_LCD_DO_F, 33 + index * 21, this.yPos + 40);
    }

    protected void drawOperator(JecaGui gui, RecordMath.Operator operator) {
        switch (operator) {
            case PLUS: {
                gui.drawResource(Resource.WGT_LCD_P_F, 132, this.yPos + 6);
                break;
            }
            case MINUS: {
                gui.drawResource(Resource.WGT_LCD_M_F, 139, this.yPos + 6);
                break;
            }
            case TIMES: {
                gui.drawResource(Resource.WGT_LCD_T_F, 146, this.yPos + 6);
                break;
            }
            case DIVIDE: {
                gui.drawResource(Resource.WGT_LCD_D_F, 153, this.yPos + 6);
            }
        }
    }

    public void print(BigDecimal num) {
        int d;
        String s = num.stripTrailingZeros().toPlainString();
        double f = num.floatValue();
        int len = f > 0.0 ? 7 : 6;
        int sca = num.unscaledValue().abs().toString().length() - num.scale() - 1;
        if (Math.abs(sca) > len) {
            String scale = String.valueOf(sca);
            format.setMaximumFractionDigits(len -= scale.length() + 2);
            s = format.format(num);
        }
        if ((d = s.indexOf(46)) >= 0 && d <= 7) {
            this.text = s.substring(0, d) + s.substring(d + 1, Math.min(s.length(), 8));
            this.dot = this.text.length() - d;
        } else {
            this.text = s;
            this.dot = -1;
        }
    }

    static {
        PATTERN.put(Character.valueOf('0'), new boolean[]{true, true, true, true, true, true, false});
        PATTERN.put(Character.valueOf('1'), new boolean[]{false, true, true, false, false, false, false});
        PATTERN.put(Character.valueOf('2'), new boolean[]{true, true, false, true, true, false, true});
        PATTERN.put(Character.valueOf('3'), new boolean[]{true, true, true, true, false, false, true});
        PATTERN.put(Character.valueOf('4'), new boolean[]{false, true, true, false, false, true, true});
        PATTERN.put(Character.valueOf('5'), new boolean[]{true, false, true, true, false, true, true});
        PATTERN.put(Character.valueOf('6'), new boolean[]{true, false, true, true, true, true, true});
        PATTERN.put(Character.valueOf('7'), new boolean[]{true, true, true, false, false, false, false});
        PATTERN.put(Character.valueOf('8'), new boolean[]{true, true, true, true, true, true, true});
        PATTERN.put(Character.valueOf('9'), new boolean[]{true, true, true, true, false, true, true});
        PATTERN.put(Character.valueOf('E'), new boolean[]{true, false, false, true, true, true, true});
        PATTERN.put(Character.valueOf('o'), new boolean[]{false, false, true, true, true, false, true});
        PATTERN.put(Character.valueOf('r'), new boolean[]{false, false, false, false, true, false, true});
        PATTERN.put(Character.valueOf('-'), new boolean[]{false, false, false, false, false, false, true});
        PATTERN.put(Character.valueOf(' '), new boolean[]{false, false, false, false, false, false, false});
    }
}

