/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class LPlaceholder
extends ILabel.Impl {
    public static final String KEY_NAME = "name";
    public static final String IDENTIFIER = "placeholder";
    public static boolean state = true;
    static Utilities.Recent<LPlaceholder> recentClient = new Utilities.Recent(100);
    static Utilities.Recent<LPlaceholder> recentServer = new Utilities.Recent(100);
    String name;

    static Utilities.Recent<LPlaceholder> getActive() {
        return state ? recentClient : recentServer;
    }

    public LPlaceholder(CompoundNBT tag) {
        super(tag);
        this.name = tag.func_74779_i(KEY_NAME);
        LPlaceholder.getActive().push(new LPlaceholder(this.name, 1L, true), false);
    }

    public LPlaceholder(String name, long amount) {
        this(name, amount, false);
    }

    public LPlaceholder(String name, long amount, boolean silent) {
        super(amount, false);
        this.name = name;
        if (!silent) {
            LPlaceholder.getActive().push(new LPlaceholder(name, 1L, true), false);
        }
    }

    public LPlaceholder(LPlaceholder label) {
        super(label);
        this.name = label.name;
    }

    @SubscribeEvent
    public static void onLogOut(ClientPlayerNetworkEvent.LoggedOutEvent e) {
        recentServer.clear();
        state = true;
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    public static List<ILabel> getRecent() {
        return LPlaceholder.getActive().toList().stream().map(LPlaceholder::copy).collect(Collectors.toList());
    }

    @Override
    public CompoundNBT toNbt() {
        CompoundNBT nbt = super.toNbt();
        nbt.func_74778_a(KEY_NAME, this.name);
        return nbt;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawResource(Resource.LBL_UNIV_B, 0, 0);
        gui.drawResource(Resource.LBL_UNIV_F, 0, 0, this.name.hashCode() * 1251107 & 0xFFFFFF);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ super.hashCode();
    }

    @Override
    @Nullable
    public Object getRepresentation() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return Utilities.I18n.get("label.placeholder.name", this.name);
    }

    @Override
    public boolean matches(Object l) {
        return l instanceof LPlaceholder && this.name.equals(((LPlaceholder)l).name) && super.matches(l);
    }

    @Override
    public LPlaceholder copy() {
        return new LPlaceholder(this);
    }

    @Override
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        existing.add("\u00a79\u00a7oJust Enough Calculation");
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LPlaceholder && b instanceof LPlaceholder) {
            LPlaceholder lpA = (LPlaceholder)a;
            LPlaceholder lpB = (LPlaceholder)b;
            return lpA.name.equals(lpB.name);
        }
        return false;
    }

    public static class Converter {
        static List<Pair<Pattern, Function<Matcher, LPlaceholder>>> converters = Arrays.asList(new Pair<Pattern, Function<Matcher, LPlaceholder>>(Pattern.compile("\\[\\[Gas: mekanism:(.+)], (\\d+)]"), i -> new LPlaceholder("Gas - " + Converter.capitalize(i.group(1)), Integer.parseInt(i.group(2)))));

        public static String capitalize(String s) {
            String[] arr = s.replace('_', ' ').split(" ");
            StringBuilder sb = new StringBuilder();
            for (String value : arr) {
                sb.append(Character.toUpperCase(value.charAt(0)));
                sb.append(value.substring(1)).append(" ");
            }
            return sb.toString().trim();
        }

        public static LPlaceholder from(Object o) {
            String s = o.toString();
            return converters.stream().map(i -> {
                Matcher m = ((Pattern)i.one).matcher(s);
                return m.matches() ? (LPlaceholder)((Function)i.two).apply(m) : null;
            }).filter(Objects::nonNull).findFirst().orElseGet(() -> new LPlaceholder(s, 1L));
        }
    }
}

