/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.Context;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LItemStack
extends LStack<Item> {
    public static final String IDENTIFIER = "itemStack";
    public static final String KEY_ITEM = "item";
    public static final String KEY_NBT = "nbt";
    public static final String KEY_CAP = "cap";
    public static final String KEY_F_META = "fMeta";
    public static final String KEY_F_CAP = "fCap";
    public static final String KEY_F_NBT = "fNbt";
    Item item;
    CompoundNBT nbt;
    CompoundNBT cap;
    boolean fMeta;
    boolean fNbt;
    boolean fCap;
    transient ItemStack rep;

    public LItemStack(ItemStack is) {
        super(is.func_190916_E(), false);
        this.init(is.func_77973_b(), LItemStack.getCap(is), is.func_77978_p(), false, false, false);
    }

    public LItemStack(CompoundNBT tag) {
        super(tag);
        String id = tag.func_74779_i(KEY_ITEM);
        Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (i == null) {
            throw new ILabel.Serializer.SerializationException("Item " + id + " cannot be resolved, ignoring");
        }
        this.init(i, tag.func_74764_b(KEY_CAP) ? tag.func_74775_l(KEY_CAP) : null, tag.func_74764_b(KEY_NBT) ? tag.func_74775_l(KEY_NBT) : null, tag.func_74767_n(KEY_F_META), tag.func_74767_n(KEY_F_CAP), tag.func_74767_n(KEY_F_NBT));
    }

    @Override
    public Item get() {
        return this.item;
    }

    @Override
    public Context<Item> getContext() {
        return Context.ITEM;
    }

    private LItemStack(LItemStack lis) {
        super(lis);
        this.item = lis.item;
        this.nbt = lis.nbt == null ? null : lis.nbt.func_74737_b();
        this.cap = lis.cap == null ? null : lis.cap.func_74737_b();
        this.fMeta = lis.fMeta;
        this.fNbt = lis.fNbt;
        this.fCap = lis.fCap;
        this.rep = lis.rep;
    }

    private void init(@Nullable Item item, @Nullable CompoundNBT cap, @Nullable CompoundNBT nbt, boolean fMeta, boolean fCap, boolean fNbt) {
        Objects.requireNonNull(item);
        this.item = item;
        this.cap = cap;
        this.nbt = nbt;
        this.fMeta = fMeta;
        this.fCap = fCap;
        this.fNbt = fNbt;
        this.rep = new ItemStack((IItemProvider)item, 1, this.cap);
        this.rep.func_77982_d(this.nbt);
    }

    @Nullable
    private static CompoundNBT getCap(ItemStack is) {
        CompoundNBT nbt = is.serializeNBT();
        return nbt.func_74764_b("ForgeCaps") ? nbt.func_74775_l("ForgeCaps") : null;
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LItemStack && b instanceof LItemStack) {
            LItemStack lisA = (LItemStack)a;
            LItemStack lisB = (LItemStack)b;
            if (lisA.rep.func_77952_i() != lisB.rep.func_77952_i() && !lisA.fMeta && !lisB.fMeta) {
                return false;
            }
            if (!lisA.fNbt && !lisB.fNbt && (lisA.nbt == null ? lisB.nbt != null : lisB.nbt == null || !lisA.nbt.equals((Object)lisB.nbt))) {
                return false;
            }
            if (!lisA.fCap && !lisB.fCap && (lisA.cap == null ? lisB.cap != null : lisB.cap == null || !lisA.cap.equals((Object)lisB.cap))) {
                return false;
            }
            return lisA.item == lisB.item;
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable Class<?> context) {
        if (iss.size() == 0) {
            return new ArrayList<ILabel>();
        }
        for (ILabel i : iss) {
            if (i instanceof LItemStack) continue;
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)iss.get(0);
        boolean fMeta = false;
        boolean fNbt = false;
        boolean fCap = false;
        for (ILabel i : iss) {
            LItemStack ii = (LItemStack)i;
            if (ii.item != lis.item) {
                return new ArrayList<ILabel>();
            }
            if (ii.rep.func_77952_i() != lis.rep.func_77952_i() || ii.fMeta) {
                fMeta = true;
            }
            if (!Objects.equals(ii.nbt, lis.nbt)) {
                fNbt = true;
            }
            if (Objects.equals(ii.cap, lis.cap)) continue;
            fCap = true;
        }
        if (fMeta || fNbt || fCap) {
            return Collections.singletonList(lis.copy().setFCap(fCap).setFMeta(fMeta).setFNbt(fNbt));
        }
        return new ArrayList<ILabel>();
    }

    public static List<ILabel> fallback(List<ILabel> iss, @Nullable Class<?> context) {
        ArrayList<ILabel> ret = new ArrayList<ILabel>();
        if (iss.size() == 1) {
            ILabel label = iss.get(0);
            if (!(label instanceof LItemStack)) {
                return ret;
            }
            LItemStack lis = (LItemStack)label;
            if (lis.fCap || lis.fNbt || lis.fMeta) {
                return new ArrayList<ILabel>();
            }
            ret.add(lis.copy().setFMeta(true));
            ret.add(lis.copy().setFNbt(true));
            ret.add(lis.copy().setFCap(true));
            ret.add(lis.copy().setFMeta(true).setFNbt(true).setFCap(true));
        }
        return ret;
    }

    public LItemStack setFMeta(boolean f) {
        this.fMeta = f;
        return this;
    }

    public LItemStack setFNbt(boolean f) {
        this.fNbt = f;
        return this;
    }

    public LItemStack setFCap(boolean f) {
        this.fCap = f;
        return this;
    }

    @Override
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        if (this.fMeta) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_meta", new Object[0]));
        }
        if (this.fNbt) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_nbt", new Object[0]));
        }
        if (this.fCap) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_cap", new Object[0]));
        }
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.item));
    }

    public ItemStack getRepresentation() {
        return this.rep;
    }

    @Override
    public String getDisplayName() {
        return this.rep.func_200301_q().getString();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LItemStack) {
            LItemStack lis = (LItemStack)l;
            return Objects.equals(this.nbt, lis.nbt) && Objects.equals(this.cap, lis.cap) && this.item == lis.item && this.fNbt == lis.fNbt && super.matches(l) && this.fCap == lis.fCap && this.fMeta == lis.fMeta;
        }
        return false;
    }

    @Override
    public LItemStack copy() {
        return new LItemStack(this);
    }

    @Override
    public CompoundNBT toNbt() {
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item);
        if (rl == null) {
            return ILabel.EMPTY.toNbt();
        }
        CompoundNBT ret = super.toNbt();
        ret.func_74778_a(KEY_ITEM, rl.toString());
        if (this.nbt != null) {
            ret.func_218657_a(KEY_NBT, (INBT)this.nbt);
        }
        if (this.cap != null) {
            ret.func_218657_a(KEY_CAP, (INBT)this.cap);
        }
        if (this.fMeta) {
            ret.func_74757_a(KEY_F_META, true);
        }
        if (this.fNbt) {
            ret.func_74757_a(KEY_F_NBT, true);
        }
        if (this.fCap) {
            ret.func_74757_a(KEY_F_CAP, true);
        }
        return ret;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawItemStack(0, 0, this.rep, false);
        if (this.fCap || this.fNbt || this.fMeta) {
            gui.drawResource(Resource.LBL_FRAME, 0, 0);
        }
        if (this.fCap) {
            gui.drawResource(Resource.LBL_FR_LL, 0, 0);
        }
        if (this.fNbt) {
            gui.drawResource(Resource.LBL_FR_UL, 0, 0);
        }
        if (this.fMeta) {
            gui.drawResource(Resource.LBL_FR_UR, 0, 0);
        }
    }

    @Override
    public int hashCode() {
        return (this.nbt == null ? 0 : this.nbt.hashCode()) ^ (this.cap == null ? 0 : this.cap.hashCode()) ^ this.item.func_77658_a().hashCode() ^ super.hashCode();
    }
}

