/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.JecaCapability;
import me.towdium.jecalculation.JecaConfig;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.network.packets.PCalculator;
import me.towdium.jecalculation.network.packets.PEdit;
import me.towdium.jecalculation.network.packets.PRecord;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod(value="jecalculation")
public class JustEnoughCalculation {
    public static final String MODID = "jecalculation";
    public static final String MODNAME = "Just Enough Calculation";
    public static final String PROTOCOL = "1";
    public static SimpleChannel network;
    public static Logger logger;

    public JustEnoughCalculation() {
        Utilities.config().mkdirs();
        String cfgPath = FMLPaths.CONFIGDIR.get().resolve("jecalculation/config.toml").toString();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, JecaConfig.common, cfgPath);
    }

    @SubscribeEvent
    public static void onConstruct(FMLConstructModEvent event) {
        Utilities.Greetings.send(logger, MODID);
    }

    @SubscribeEvent
    public static void setupCommon(FMLCommonSetupEvent event) {
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "main"), () -> PROTOCOL, v -> v.equals(PROTOCOL) || v.equals(NetworkRegistry.ABSENT), v -> v.equals(PROTOCOL) || v.equals(NetworkRegistry.ABSENT));
        network.registerMessage(0, PCalculator.class, PCalculator::write, PCalculator::new, PCalculator::handle);
        network.registerMessage(1, PEdit.class, PEdit::write, PEdit::new, PEdit::handle);
        network.registerMessage(2, PRecord.class, PRecord::write, PRecord::new, PRecord::handle);
        CapabilityManager.INSTANCE.register(JecaCapability.Container.class, (Capability.IStorage)new JecaCapability.Storage(), JecaCapability.Container::new);
        ILabel.initServer();
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ILabel.initClient();
        Controller.loadFromLocal();
        ClientRegistry.registerKeyBinding((KeyBinding)JecaGui.keyOpenGuiCraft);
        ClientRegistry.registerKeyBinding((KeyBinding)JecaGui.keyOpenGuiMath);
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }
}

