/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class ClaimableRecipeWrapper
extends RecipeWrapper {
    private final IItemHandler unusedInputs;
    private final IItemHandler inputsBeingSmelted;
    private List<IRecipe<ClaimableRecipeWrapper>> recipes = new ArrayList<IRecipe<ClaimableRecipeWrapper>>();

    public ClaimableRecipeWrapper(IItemHandlerModifiable inv) {
        super(inv);
        int slots = inv.getSlots();
        this.unusedInputs = new ItemStackHandler(slots);
        this.inputsBeingSmelted = new ItemStackHandler(slots);
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackCopy = inv.getStackInSlot(slot).func_77946_l();
            for (int i = 0; i < slots && stackCopy.func_190916_E() > 0; ++i) {
                stackCopy = this.unusedInputs.insertItem(i, stackCopy, false);
            }
        }
    }

    public List<IRecipe<ClaimableRecipeWrapper>> getRecipes() {
        return this.recipes;
    }

    public IItemHandler getItemsBeingSmelted() {
        return this.inputsBeingSmelted;
    }

    public int getRecipeCount() {
        return this.recipes.size();
    }

    public boolean hasUnusedInputsLeft() {
        int slots = this.unusedInputs.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (this.unusedInputs.getStackInSlot(slot).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public IItemHandler getUnusedInputs() {
        int slots = this.unusedInputs.getSlots();
        ItemStackHandler result = new ItemStackHandler(slots);
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackInSlot = this.unusedInputs.getStackInSlot(slot);
            result.insertItem(slot, stackInSlot.func_77946_l(), false);
        }
        return result;
    }

    public boolean matchAndClaimInputs(IRecipe<ClaimableRecipeWrapper> recipe, World world) {
        boolean matched = recipe.func_77569_a((IInventory)this, world);
        if (matched) {
            NonNullList ingredients = recipe.func_192400_c();
            for (Ingredient ingredient : ingredients) {
                int amountOfIngredient = ingredient.func_193365_a()[0].func_190916_E();
                int slots = this.unusedInputs.getSlots();
                for (int slot = 0; slot < slots && amountOfIngredient > 0; ++slot) {
                    ItemStack stackInSlot = this.unusedInputs.getStackInSlot(slot);
                    if (!ingredient.test(stackInSlot) || stackInSlot.func_190916_E() < amountOfIngredient) continue;
                    ItemStack usedStack = this.unusedInputs.extractItem(slot, amountOfIngredient, false);
                    int usedInputSlots = this.inputsBeingSmelted.getSlots();
                    amountOfIngredient -= usedStack.func_190916_E();
                    for (int usedInputSlot = 0; usedInputSlot < usedInputSlots && usedStack.func_190916_E() > 0; ++usedInputSlot) {
                        usedStack = this.inputsBeingSmelted.insertItem(usedInputSlot, usedStack, false);
                    }
                }
            }
            this.recipes.add(recipe);
        }
        return matched;
    }
}

