/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.ingredients.IngredientsForType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class Ingredients
implements IIngredients {
    private final List<IngredientsForType<?>> inputs = new ArrayList();
    private final List<IngredientsForType<?>> outputs = new ArrayList();

    @Override
    public <T> void setInput(IIngredientType<T> ingredientType, T input) {
        this.setInputs(ingredientType, Collections.singletonList(input));
    }

    @Override
    public <T> void setInputLists(IIngredientType<T> ingredientType, List<List<T>> inputs) {
        ArrayList<List<T>> expandedInputs = new ArrayList<List<T>>(inputs);
        Ingredients.setIngredients(ingredientType, this.inputs, expandedInputs);
    }

    @Override
    public void setInputIngredients(List<Ingredient> inputs) {
        ArrayList inputLists = new ArrayList();
        for (Ingredient input : inputs) {
            ItemStack[] stacks = input.func_193365_a();
            List<ItemStack> expandedInput = Arrays.asList(stacks);
            inputLists.add(expandedInput);
        }
        Ingredients.setIngredients(VanillaTypes.ITEM, this.inputs, inputLists);
    }

    @Override
    public <T> void setInputs(IIngredientType<T> ingredientType, List<T> inputs) {
        ArrayList<List<T>> expandedInputs = new ArrayList<List<T>>();
        for (T input : inputs) {
            List<T> expandedInput = Collections.singletonList(input);
            expandedInputs.add(expandedInput);
        }
        Ingredients.setIngredients(ingredientType, this.inputs, expandedInputs);
    }

    @Override
    public <T> void setOutput(IIngredientType<T> ingredientType, T output) {
        this.setOutputs(ingredientType, Collections.singletonList(output));
    }

    @Override
    public <T> void setOutputs(IIngredientType<T> ingredientType, List<T> outputs) {
        ArrayList<List<T>> expandedOutputs = new ArrayList<List<T>>();
        for (T output : outputs) {
            List<T> expandedOutput = Collections.singletonList(output);
            expandedOutputs.add(expandedOutput);
        }
        Ingredients.setIngredients(ingredientType, this.outputs, expandedOutputs);
    }

    @Override
    public <T> void setOutputLists(IIngredientType<T> ingredientType, List<List<T>> outputs) {
        ArrayList<List<T>> expandedOutputs = new ArrayList<List<T>>(outputs);
        Ingredients.setIngredients(ingredientType, this.outputs, expandedOutputs);
    }

    @Override
    public <T> List<List<T>> getInputs(IIngredientType<T> ingredientType) {
        return Ingredients.getIngredients(ingredientType, this.inputs);
    }

    @Override
    public <T> List<List<T>> getOutputs(IIngredientType<T> ingredientType) {
        return Ingredients.getIngredients(ingredientType, this.outputs);
    }

    public List<IngredientsForType<?>> getInputIngredients() {
        return this.inputs;
    }

    public List<IngredientsForType<?>> getOutputIngredients() {
        return this.outputs;
    }

    private static <T> void setIngredients(IIngredientType<T> ingredientType, List<IngredientsForType<?>> ingredientsForTypes, List<List<T>> ingredients) {
        IngredientsForType<T> recipeIngredients = Ingredients.getIngredientsForType(ingredientType, ingredientsForTypes);
        if (recipeIngredients == null) {
            ingredientsForTypes.add(new IngredientsForType<T>(ingredientType, ingredients));
        } else {
            recipeIngredients.setIngredients(ingredients);
        }
    }

    private static <T> List<List<T>> getIngredients(IIngredientType<T> ingredientType, List<IngredientsForType<?>> ingredientsForTypes) {
        IngredientsForType<T> recipeIngredients = Ingredients.getIngredientsForType(ingredientType, ingredientsForTypes);
        if (recipeIngredients == null) {
            return Collections.emptyList();
        }
        return recipeIngredients.getIngredients();
    }

    @Nullable
    private static <T> IngredientsForType<T> getIngredientsForType(IIngredientType<T> ingredientType, List<IngredientsForType<?>> ingredientsForTypes) {
        for (IngredientsForType<?> i : ingredientsForTypes) {
            if (i.getIngredientType() != ingredientType) continue;
            IngredientsForType<?> ingredientsForType = i;
            return ingredientsForType;
        }
        return null;
    }
}

