/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.mininglevel.v1.FabricMineableTags;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1820;
import net.minecraft.class_1833;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeServerCommand;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.mixin.AbstractHorseAccess;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeFabricUtils;
import snownee.jade.util.TechRebornEnergyCompat;
import snownee.jade.util.UsernameCache;
import snownee.jade.util.WailaExceptionHandler;
import team.reborn.energy.api.EnergyStorage;

public final class CommonProxy
implements ModInitializer {
    public static final class_6862<class_1299<?>> BOSSES = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("c:bosses"));
    public static boolean hasTechRebornEnergy = CommonProxy.isModLoaded("team_reborn_energy");

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        return UsernameCache.getLastKnownUsername(uuid);
    }

    public static File getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    public static boolean isShears(class_1799 tool) {
        return tool.method_7909() instanceof class_1820;
    }

    public static boolean isShearable(class_2680 state) {
        return state.method_26164(FabricMineableTags.SHEARS_MINEABLE);
    }

    public static boolean isCorrectToolForDrops(class_2680 state, class_1657 player) {
        return player.method_7305(state);
    }

    public static String getModIdFromItem(class_1799 stack) {
        class_2487 compoundTag;
        class_2960 id;
        String s;
        if (stack.method_7969() != null && stack.method_7969().method_10545("id") && (s = stack.method_7969().method_10558("id")).contains(":") && (id = class_2960.method_12829((String)s)) != null) {
            return id.method_12836();
        }
        if (stack.method_7909() instanceof class_1772) {
            class_2499 listTag = class_1772.method_7806((class_1799)stack);
            String modid = null;
            for (int i = 0; i < listTag.size(); ++i) {
                class_2960 enchantmentId = class_1890.method_37427((class_2487)listTag.method_10602(i));
                if (enchantmentId == null) continue;
                String namespace = enchantmentId.method_12836();
                if (modid == null) {
                    modid = namespace;
                    continue;
                }
                if (modid.equals(namespace)) continue;
                modid = null;
                break;
            }
            if (modid != null) {
                return modid;
            }
        }
        if (stack.method_7909() instanceof class_1812 || stack.method_7909() instanceof class_1833) {
            class_1842 potion = class_1844.method_8063((class_1799)stack);
            return class_7923.field_41179.method_10221((Object)potion).method_12836();
        }
        if (stack.method_31574(class_1802.field_8892) && (compoundTag = stack.method_7969()) != null && compoundTag.method_10573("EntityTag", 10)) {
            class_2487 compoundTag2 = compoundTag.method_10562("EntityTag");
            return class_1534.method_48929((class_2487)compoundTag2).flatMap(class_6880::method_40230).map(class_5321::method_29177).map(class_2960::method_12836).orElse("minecraft");
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
    }

    public static boolean isPhysicallyClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static ItemCollector<?> createItemStorageCache(Object target, Cache<Object, ItemCollector<?>> containerCache) {
        if (target instanceof AbstractHorseAccess) {
            return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(o -> {
                if (o instanceof AbstractHorseAccess) {
                    AbstractHorseAccess horse = (AbstractHorseAccess)o;
                    return horse.getInventory();
                }
                return null;
            }, 2));
        }
        if (target instanceof class_2586) {
            class_2586 be = (class_2586)target;
            try {
                Storage storage = (Storage)ItemStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, null);
                if (storage != null) {
                    return (ItemCollector)containerCache.get((Object)storage, () -> new ItemCollector<Storage<ItemVariant>>(JadeFabricUtils.fromItemStorage((Storage<ItemVariant>)storage, 0)));
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        if (target instanceof class_1263) {
            if (target instanceof class_2595) {
                return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(o -> {
                    if (o instanceof class_2595) {
                        class_2281 chestBlock;
                        class_1263 compound;
                        class_2595 be = (class_2595)o;
                        class_2248 patt8444$temp = be.method_11010().method_26204();
                        if (patt8444$temp instanceof class_2281 && (compound = class_2281.method_17458((class_2281)(chestBlock = (class_2281)patt8444$temp), (class_2680)be.method_11010(), (class_1937)be.method_10997(), (class_2338)be.method_11016(), (boolean)false)) != null) {
                            return compound;
                        }
                        return be;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Nullable
    public static List<ViewGroup<class_1799>> containerGroup(class_1263 container, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.INSTANCE.containerCache.get((Object)container, () -> new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(0)))).update(container, accessor.getLevel().method_8510());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public static List<ViewGroup<class_1799>> storageGroup(Object storage, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.INSTANCE.containerCache.get(storage, () -> new ItemCollector<Storage<ItemVariant>>(JadeFabricUtils.fromItemStorage((Storage<ItemVariant>)((Storage)storage), 0)))).update(storage, accessor.getLevel().method_8510());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static List<ViewGroup<class_2487>> wrapFluidStorage(Object target, class_3222 player) {
        if (target instanceof class_2586) {
            class_2586 be = (class_2586)target;
            try {
                Storage storage = (Storage)FluidStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, null);
                if (storage != null) {
                    return JadeFabricUtils.fromFluidStorage((Storage<FluidVariant>)storage);
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        return null;
    }

    public static List<ViewGroup<class_2487>> wrapEnergyStorage(Object target, class_3222 player) {
        if (hasTechRebornEnergy && target instanceof class_2586) {
            class_2586 be = (class_2586)target;
            try {
                EnergyStorage storage = (EnergyStorage)TechRebornEnergyCompat.getSided().find(be.method_10997(), be.method_11016(), be.method_11010(), be, null);
                if (storage != null && storage.getCapacity() > 0L) {
                    ViewGroup<class_2487> group = new ViewGroup<class_2487>(List.of(EnergyView.of(storage.getAmount(), storage.getCapacity())));
                    group.getExtraData().method_10582("Unit", "E");
                    return List.of(group);
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        return null;
    }

    public static boolean isDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static float getEnchantPowerBonus(class_2680 state, class_1937 world, class_2338 pos) {
        if (WailaClientRegistration.INSTANCE.customEnchantPowers.containsKey(state.method_26204())) {
            return WailaClientRegistration.INSTANCE.customEnchantPowers.get(state.method_26204()).getEnchantPowerBonus(state, world, pos);
        }
        return state.method_27852(class_2246.field_10504) ? 1.0f : 0.0f;
    }

    public static class_2960 getId(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static class_2960 getId(class_1299<?> entityType) {
        return class_7923.field_41177.method_10221(entityType);
    }

    public static class_2960 getId(class_2591<?> blockEntityType) {
        return class_7923.field_41181.method_10221(blockEntityType);
    }

    public static class_2960 getId(class_1535 motive) {
        return class_7923.field_41182.method_10221((Object)motive);
    }

    public static String getPlatformIdentifier() {
        return "fabric";
    }

    public static class_5250 getProfressionName(class_3852 profession) {
        return class_2561.method_43471((String)(class_1299.field_6077.method_5882() + "." + class_7923.field_41195.method_10221((Object)profession).method_12832()));
    }

    private static void registerServerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        JadeServerCommand.register(dispatcher);
    }

    public static boolean isBoss(class_1297 entity) {
        class_1299 entityType = entity.method_5864();
        return entityType.method_20210(BOSSES) || entityType == class_1299.field_6116 || entityType == class_1299.field_6119;
    }

    public static class_1799 getBlockPickedResult(class_2680 state, class_1657 player, class_3965 hitResult) {
        class_2248 block = state.method_26204();
        if (CommonProxy.isPhysicallyClient()) {
            class_1799 result = ClientProxy.invokePickEvent(player, (class_239)hitResult);
            if (!result.method_7960()) {
                return result;
            }
        } else if (block instanceof BlockPickInteractionAware) {
            return ((BlockPickInteractionAware)block).getPickedStack(state, (class_1922)player.method_37908(), hitResult.method_17777(), player, (class_239)hitResult);
        }
        return block.method_9574((class_1922)player.method_37908(), hitResult.method_17777(), state);
    }

    public static class_1799 getEntityPickedResult(class_1297 entity, class_1657 player, class_3966 hitResult) {
        class_1799 stack;
        if (CommonProxy.isPhysicallyClient()) {
            class_1799 result = ClientProxy.invokePickEvent(player, (class_239)hitResult);
            if (!result.method_7960()) {
                return result;
            }
        } else if (entity instanceof EntityPickInteractionAware) {
            return ((EntityPickInteractionAware)entity).getPickedStack(player, (class_239)hitResult);
        }
        return (stack = entity.method_31480()) == null ? class_1799.field_8037 : stack;
    }

    private static void playerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 player = handler.field_14140;
        Jade.LOGGER.info("Syncing config to {} ({})", (Object)player.method_7334().getName(), (Object)player.method_7334().getId());
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(Strings.nullToEmpty((String)PluginConfig.INSTANCE.getServerConfigs()));
        ServerPlayNetworking.send((class_3222)player, (class_2960)Identifiers.PACKET_SERVER_PING, (class_2540)buf);
        if (server.method_3816() && !(player instanceof FakePlayer)) {
            UsernameCache.setUsername(player.method_5667(), player.method_7334().getName());
        }
    }

    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static void loadComplete() {
        FabricLoader.getInstance().getEntrypointContainers("jade", IWailaPlugin.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            Jade.LOGGER.info("Start loading plugin from {}", (Object)metadata.getName());
            String className = null;
            try {
                IWailaPlugin plugin = (IWailaPlugin)entrypoint.getEntrypoint();
                WailaPlugin a = plugin.getClass().getDeclaredAnnotation(WailaPlugin.class);
                if (a != null && !Strings.isNullOrEmpty((String)a.value()) && !CommonProxy.isModLoaded(a.value())) {
                    return;
                }
                className = plugin.getClass().getName();
                plugin.register(WailaCommonRegistration.INSTANCE);
                if (CommonProxy.isPhysicallyClient()) {
                    plugin.registerClient(WailaClientRegistration.INSTANCE);
                }
            }
            catch (Throwable e) {
                Jade.LOGGER.error("Error loading plugin at {}", className, (Object)e);
            }
        });
        Jade.loadComplete();
    }

    public static class_2561 getFluidName(JadeFluidObject fluidObject) {
        class_3611 fluid = fluidObject.getType();
        class_2487 nbt = fluidObject.getTag();
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid, (class_2487)nbt));
    }

    public static int showOrHideFromServer(Collection<class_3222> players, boolean show) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(show);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)Identifiers.PACKET_SHOW_OVERLAY, (class_2540)buf);
        }
        return players.size();
    }

    public static boolean isMultipartEntity(class_1297 target) {
        return target instanceof class_1510;
    }

    public static class_1297 wrapPartEntityParent(class_1297 target) {
        if (target instanceof class_1508) {
            class_1508 part = (class_1508)target;
            return part.field_7007;
        }
        return target;
    }

    public static int getPartEntityIndex(class_1297 entity) {
        if (!(entity instanceof class_1508)) {
            return -1;
        }
        class_1508 part = (class_1508)entity;
        class_1297 class_12972 = CommonProxy.wrapPartEntityParent(entity);
        if (!(class_12972 instanceof class_1510)) {
            return -1;
        }
        class_1510 parent = (class_1510)class_12972;
        class_1508[] parts = parent.method_5690();
        return List.of(parts).indexOf(part);
    }

    public static class_1297 getPartEntity(class_1297 parent, int index) {
        class_1510 dragon;
        class_1508[] parts;
        if (parent == null) {
            return null;
        }
        if (index < 0) {
            return parent;
        }
        if (parent instanceof class_1510 && index < (parts = (dragon = (class_1510)parent).method_5690()).length) {
            return parts[index];
        }
        return parent;
    }

    public void onInitialize() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Identifiers.PACKET_REQUEST_ENTITY, (server, player, handler, buf, responseSender) -> EntityAccessorImpl.handleRequest(buf, player, arg_0 -> ((MinecraftServer)server).execute(arg_0), tag -> {
            class_2540 data = PacketByteBufs.create();
            data.method_10794(tag);
            responseSender.sendPacket(Identifiers.PACKET_RECEIVE_DATA, data);
        }));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Identifiers.PACKET_REQUEST_TILE, (server, player, handler, buf, responseSender) -> BlockAccessorImpl.handleRequest(buf, player, arg_0 -> ((MinecraftServer)server).execute(arg_0), tag -> {
            class_2540 data = PacketByteBufs.create();
            data.method_10794(tag);
            responseSender.sendPacket(Identifiers.PACKET_RECEIVE_DATA, data);
        }));
        CommandRegistrationCallback.EVENT.register(CommonProxy::registerServerCommand);
        ServerPlayConnectionEvents.JOIN.register(CommonProxy::playerJoin);
        UsernameCache.load();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (server.method_3816()) {
                CommonProxy.loadComplete();
            }
        });
    }
}

