/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.itemcollectors.CollectorBlock;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.ItemCollectorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class CollectorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private static final int MIN_RANGE = 1;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;
    public int rangeX;
    public int rangeY;
    public int rangeZ;
    public final List<class_1799> filter = new ArrayList<class_1799>(9);
    public boolean filterWhitelist;
    public boolean filterDurability = true;
    public boolean showArea = false;

    public static CollectorBlockEntity basicCollectorEntity(class_2338 pos, class_2680 state) {
        return new CollectorBlockEntity(ItemCollectors.basic_collector_tile, pos, state, ItemCollectorsConfig.basicCollectorMaxRange, ItemCollectorsConfig.basicCollectorFilter);
    }

    public static CollectorBlockEntity advancedCollectorEntity(class_2338 pos, class_2680 state) {
        return new CollectorBlockEntity(ItemCollectors.advanced_collector_tile, pos, state, ItemCollectorsConfig.advancedCollectorMaxRange, ItemCollectorsConfig.advancedCollectorFilter);
    }

    public CollectorBlockEntity(BaseBlockEntityType<CollectorBlockEntity> blockEntityType, class_2338 pos, class_2680 state, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(blockEntityType, pos, state);
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = (int)Math.ceil((float)maxRange.get().intValue() / 2.0f);
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(class_1799.field_8037);
        }
    }

    public void update() {
        Storage<ItemVariant> itemHandler;
        if (!this.field_11863.field_9236 && (itemHandler = this.getOutputItemHandler()) != null) {
            if (!itemHandler.supportsInsertion()) {
                return;
            }
            class_238 area = this.getAffectedArea();
            List items = this.field_11863.method_8390(class_1542.class, area, item -> {
                if (!item.method_5805()) {
                    return false;
                }
                class_1799 stack = item.method_6983();
                if (stack.method_7960()) {
                    return false;
                }
                if (!this.hasFilter.get().booleanValue()) {
                    return true;
                }
                for (int i = 0; i < 9; ++i) {
                    class_1799 filter = this.filter.get(i);
                    if (!class_1799.method_7984((class_1799)filter, (class_1799)stack) || this.filterDurability && !class_1799.method_31577((class_1799)filter, (class_1799)stack)) continue;
                    return this.filterWhitelist;
                }
                return !this.filterWhitelist;
            });
            for (class_1542 entity : items) {
                class_1799 stack = entity.method_6983().method_7972();
                ItemVariant variant = ItemVariant.of((class_1799)stack);
                try (Transaction transaction = Transaction.openOuter();){
                    long inserted = itemHandler.insert((Object)variant, (long)stack.method_7947(), (TransactionContext)transaction);
                    if (inserted <= 0L || inserted > (long)stack.method_7947()) continue;
                    transaction.commit();
                    stack.method_7934((int)inserted);
                    entity.method_6979(stack);
                    if (!stack.method_7960()) continue;
                    entity.method_5650(class_1297.class_5529.field_26999);
                }
            }
        }
    }

    public class_238 getAffectedArea() {
        return new class_238(this.field_11867.method_10069(-this.rangeX, -this.rangeY, -this.rangeZ), this.field_11867.method_10069(this.rangeX + 1, this.rangeY + 1, this.rangeZ + 1));
    }

    private Storage<ItemVariant> getOutputItemHandler() {
        if (this.field_11863.field_9236) {
            return null;
        }
        class_2680 state = this.method_11010();
        if (!state.method_28498(CollectorBlock.DIRECTION)) {
            return null;
        }
        class_2350 direction = (class_2350)state.method_11654(CollectorBlock.DIRECTION);
        return (Storage)ItemStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(direction), (Object)direction.method_10153());
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public void setShowArea(boolean showArea) {
        if (this.showArea != showArea) {
            this.showArea = showArea;
            this.dataChanged();
        }
    }

    protected class_2487 writeData() {
        class_2487 tag = new class_2487();
        tag.method_10569("rangeX", this.rangeX);
        tag.method_10569("rangeY", this.rangeY);
        tag.method_10569("rangeZ", this.rangeZ);
        for (int i = 0; i < 9; ++i) {
            if (this.filter.get(i).method_7960()) continue;
            tag.method_10566("filter" + i, (class_2520)this.filter.get(i).method_7953(new class_2487()));
        }
        tag.method_10556("filterWhitelist", this.filterWhitelist);
        tag.method_10556("filterDurability", this.filterDurability);
        tag.method_10556("showArea", this.showArea);
        return tag;
    }

    protected void readData(class_2487 tag) {
        if (tag.method_10545("rangeX")) {
            this.rangeX = tag.method_10550("rangeX");
        }
        if (tag.method_10545("rangeY")) {
            this.rangeY = tag.method_10550("rangeY");
        }
        if (tag.method_10545("rangeZ")) {
            this.rangeZ = tag.method_10550("rangeZ");
        }
        for (int i = 0; i < 9; ++i) {
            this.filter.set(i, tag.method_10545("filter" + i) ? class_1799.method_7915((class_2487)tag.method_10562("filter" + i)) : class_1799.field_8037);
        }
        this.filterWhitelist = tag.method_10545("filterWhitelist") && tag.method_10577("filterWhitelist");
        this.filterDurability = tag.method_10545("filterDurability") && tag.method_10577("filterDurability");
        this.showArea = tag.method_10545("showArea") && tag.method_10577("showArea");
    }
}

