/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.api.StringValueFilterVariant;
import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TagFilterItem
extends StringValueFilterItem {
    public StringValueData createData(ItemStack stack) {
        return new TagData(stack);
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ITag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(this.getValue(filter)));
        if (tag != null && !tag.func_230236_b_().isEmpty()) {
            return tag.func_230235_a_((Object)stack.func_77973_b());
        }
        return false;
    }

    @Override
    public boolean filterItem(ItemStack filter, Item item) {
        if (item == Items.field_190931_a) {
            return false;
        }
        ITag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(this.getValue(filter)));
        if (tag != null && !tag.func_230236_b_().isEmpty()) {
            return tag.func_230235_a_((Object)item);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Collection<StringValueFilterVariant> getValueVariants(ItemStack filter) {
        ArrayList<StringValueFilterVariant> list = new ArrayList<StringValueFilterVariant>();
        for (ResourceLocation id : ItemTags.func_199903_a().func_199908_a()) {
            ITag tag = ItemTags.func_199903_a().func_199910_a(id);
            if (tag == null || tag.func_230236_b_().isEmpty()) continue;
            StringValueFilterVariant variant = new StringValueFilterVariant(id.toString());
            variant.icon = new ItemStack((IItemProvider)tag.func_230236_b_().iterator().next());
            list.add(variant);
        }
        return list;
    }

    @Override
    public void getDisplayItemStacks(ItemStack filter, List<ItemStack> list) {
        ITag items = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(this.getValue(filter)));
        if (items == null || items.func_230236_b_().isEmpty()) {
            return;
        }
        NonNullList list1 = NonNullList.func_191196_a();
        for (Item item : items.func_230236_b_()) {
            item.func_150895_a(ItemGroup.field_78027_g, list1);
        }
        list.addAll((Collection<ItemStack>)list1);
    }

    @Override
    public void getItems(ItemStack filter, Set<Item> set) {
        ITag items = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(this.getValue(filter)));
        if (items == null || items.func_230236_b_().isEmpty()) {
            return;
        }
        set.addAll(items.func_230236_b_());
    }

    public static class TagData
    extends StringValueData<ResourceLocation> {
        public TagData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        public ResourceLocation fromString(String s) {
            if (s.isEmpty()) {
                return null;
            }
            ResourceLocation id = new ResourceLocation(s);
            return ItemTags.func_199903_a().func_199910_a(id) == null ? null : id;
        }

        @Override
        public String toString(ResourceLocation value) {
            return value == null ? "" : value.toString();
        }
    }
}

