/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.api;

import dev.latvian.mods.itemfilters.api.CustomFilter;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ItemFiltersAPI {
    public static final ResourceLocation FILTERS_ITEM_TAG_ID = new ResourceLocation("itemfilters", "filters");
    public static final ResourceLocation CHECK_NBT_ITEM_TAG_ID = new ResourceLocation("itemfilters", "check_nbt");
    public static final ITag.INamedTag<Item> FILTERS_ITEM_TAG = TagHooks.getItemOptional((ResourceLocation)FILTERS_ITEM_TAG_ID);
    public static final ITag.INamedTag<Item> CHECK_NBT_ITEM_TAG = TagHooks.getItemOptional((ResourceLocation)CHECK_NBT_ITEM_TAG_ID);
    public static final Map<String, CustomFilter> CUSTOM_FILTERS = new LinkedHashMap<String, CustomFilter>();

    @Nullable
    public static IItemFilter getFilter(ItemStack stack) {
        if (stack.func_77973_b() instanceof IItemFilter) {
            return (IItemFilter)stack.func_77973_b();
        }
        return null;
    }

    public static boolean isFilter(ItemStack stack) {
        return stack.func_77973_b() instanceof IItemFilter;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (!stackA.func_77942_o() && !stackB.func_77942_o()) {
            return true;
        }
        ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(CHECK_NBT_ITEM_TAG_ID);
        if (tag == null) {
            return false;
        }
        return !tag.func_230235_a_((Object)stackA.func_77973_b()) || ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean filter(ItemStack filter, ItemStack stack) {
        if (filter.func_190926_b()) {
            return true;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        return f == null ? ItemFiltersAPI.areItemStacksEqual(filter, stack) : f.filter(filter, stack);
    }

    public static void getDisplayItemStacks(ItemStack filter, List<ItemStack> list) {
        if (filter.func_190926_b()) {
            return;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        if (f == null) {
            list.add(filter);
        } else {
            f.getDisplayItemStacks(filter, list);
        }
    }

    public static void getItems(ItemStack filter, Set<Item> list) {
        if (filter.func_190926_b()) {
            return;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        if (f == null) {
            list.add(filter.func_77973_b());
        } else {
            f.getItems(filter, list);
        }
    }

    public static CustomFilter registerCustomFilter(String id, Predicate<ItemStack> predicate) {
        CustomFilter filter = new CustomFilter(id, predicate);
        CUSTOM_FILTERS.put(id, filter);
        return filter;
    }
}

