/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.network;

import com.progwml6.ironchest.common.block.tileentity.CrystalChestTileEntity;
import com.progwml6.ironchest.common.network.helper.IThreadsafePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class InventoryTopStacksSyncPacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final NonNullList<ItemStack> topStacks;

    public InventoryTopStacksSyncPacket(NonNullList<ItemStack> topStacks, BlockPos pos) {
        this.topStacks = topStacks;
        this.pos = pos;
    }

    public InventoryTopStacksSyncPacket(PacketBuffer buffer) {
        int size = buffer.readInt();
        NonNullList topStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int item = 0; item < size; ++item) {
            ItemStack itemStack = buffer.func_150791_c();
            topStacks.set(item, (Object)itemStack);
        }
        this.topStacks = topStacks;
        this.pos = buffer.func_179259_c();
    }

    @Override
    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.topStacks.size());
        for (ItemStack stack : this.topStacks) {
            packetBuffer.func_150788_a(stack);
        }
        packetBuffer.func_179255_a(this.pos);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(InventoryTopStacksSyncPacket packet) {
            TileEntity te;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (te = world.func_175625_s(packet.pos)) != null && te instanceof CrystalChestTileEntity) {
                ((CrystalChestTileEntity)te).receiveMessageFromServer((NonNullList<ItemStack>)packet.topStacks);
                Minecraft.func_71410_x().field_71438_f.func_184376_a(null, packet.pos, null, null, 0);
            }
        }
    }
}

