/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.texture;

import java.nio.ByteBuffer;
import java.util.Optional;
import net.coderbot.iris.gl.IrisRenderSystem;

public enum TextureType {
    TEXTURE_1D(3552),
    TEXTURE_2D(3553),
    TEXTURE_3D(32879),
    TEXTURE_RECTANGLE(32879);

    private final int glType;

    private TextureType(int n2) {
        this.glType = n2;
    }

    public int getGlType() {
        return this.glType;
    }

    public void apply(int n, int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        switch (this) {
            case TEXTURE_1D: {
                IrisRenderSystem.texImage1D(n, this.getGlType(), 0, n5, n2, 0, n6, n7, byteBuffer);
                break;
            }
            case TEXTURE_2D: 
            case TEXTURE_RECTANGLE: {
                IrisRenderSystem.texImage2D(n, this.getGlType(), 0, n5, n2, n3, 0, n6, n7, byteBuffer);
                break;
            }
            case TEXTURE_3D: {
                IrisRenderSystem.texImage3D(n, this.getGlType(), 0, n5, n2, n3, n4, 0, n6, n7, byteBuffer);
            }
        }
    }

    public static Optional<TextureType> fromString(String string) {
        try {
            return Optional.of(TextureType.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }
}

