/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.buffer;

import com.mojang.blaze3d.platform.GlStateManager;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;

public class ShaderStorageBuffer {
    protected int id = GlStateManager._glGenBuffers();
    protected final int index;
    protected final ShaderStorageInfo info;

    public ShaderStorageBuffer(int n, ShaderStorageInfo shaderStorageInfo) {
        this.index = n;
        this.info = shaderStorageInfo;
    }

    public final int getIndex() {
        return this.index;
    }

    public final long getSize() {
        return this.info.size();
    }

    protected void destroy() {
        IrisRenderSystem.bindBufferBase(37074, this.index, 0);
        IrisRenderSystem.deleteBuffers(this.id);
    }

    public void bind() {
        IrisRenderSystem.bindBufferBase(37074, this.index, this.id);
    }

    public void resizeIfRelative(int n, int n2) {
        if (!this.info.relative()) {
            return;
        }
        IrisRenderSystem.deleteBuffers(this.id);
        int n3 = GlStateManager._glGenBuffers();
        GlStateManager._glBindBuffer((int)37074, (int)n3);
        int n4 = (int)((float)n * this.info.scaleX());
        int n5 = (int)((float)n2 * this.info.scaleY());
        int n6 = n5 * n4 * this.info.size();
        IrisRenderSystem.bufferStorage(37074, n6, 0);
        IrisRenderSystem.clearBufferSubData(37074, 33321, 0L, n6, 6403, 5120, new int[]{0});
        IrisRenderSystem.bindBufferBase(37074, this.index, n3);
        this.id = n3;
    }

    public int getId() {
        return this.id;
    }
}

