/*
 * Decompiled with CFR 0.152.
 */
package kroppeb.stareval.function;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kroppeb.stareval.function.Type;
import kroppeb.stareval.function.TypedFunction;

public class FunctionResolver {
    private final Map<String, Map<Type, List<TypedFunction>>> functions;
    private final Map<String, Map<Type, List<Supplier<? extends TypedFunction>>>> dynamicFunctions;

    public FunctionResolver(Map<String, Map<Type, List<TypedFunction>>> map, Map<String, Map<Type, List<Supplier<? extends TypedFunction>>>> map2) {
        this.functions = map;
        this.dynamicFunctions = map2;
    }

    public List<? extends TypedFunction> resolve(String string, Type type) {
        List<Supplier<? extends TypedFunction>> list;
        Map<Type, List<TypedFunction>> map = this.functions.get(string);
        Map<Type, List<Supplier<? extends TypedFunction>>> map2 = this.dynamicFunctions.get(string);
        List<TypedFunction> list2 = null;
        if (map == null && map2 == null) {
            throw new RuntimeException("No such function: " + string);
        }
        if (map != null) {
            list2 = map.get(type);
        }
        if (map2 != null && (list = map2.get(type)) != null) {
            List list3 = list.stream().map(Supplier::get).collect(Collectors.toList());
            if (list2 == null) {
                list2 = list3;
            } else {
                ArrayList<TypedFunction> arrayList = new ArrayList<TypedFunction>(list2.size() + list3.size());
                arrayList.addAll(list2);
                arrayList.addAll(list3);
                list2 = arrayList;
            }
        }
        if (list2 == null) {
            return Collections.emptyList();
        }
        return list2;
    }

    public void logAllFunctions() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(this.functions.keySet());
        linkedHashSet.addAll(this.dynamicFunctions.keySet());
        for (String string : linkedHashSet) {
            Map<Type, List<Supplier<? extends TypedFunction>>> map;
            Object2ObjectLinkedOpenHashMap object2ObjectLinkedOpenHashMap = new Object2ObjectLinkedOpenHashMap();
            Map<Type, List<TypedFunction>> map2 = this.functions.get(string);
            if (map2 != null) {
                object2ObjectLinkedOpenHashMap.putAll(map2);
            }
            if ((map = this.dynamicFunctions.get(string)) != null) {
                object2ObjectLinkedOpenHashMap.putAll(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(Supplier::get).collect(Collectors.toList()))));
            }
            for (Map.Entry entry2 : object2ObjectLinkedOpenHashMap.entrySet()) {
                for (TypedFunction typedFunction : (List)entry2.getValue()) {
                    System.out.println(TypedFunction.format(typedFunction, string));
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public static class Builder {
        private final Map<String, List<TypedFunction>> functions = new Object2ObjectLinkedOpenHashMap();
        private final Map<String, Map<Type, List<Supplier<? extends TypedFunction>>>> dynamicFunctions = new Object2ObjectLinkedOpenHashMap();

        public <T extends TypedFunction> void add(String string, T t) {
            this.addFunction(string, t);
        }

        public <T extends TypedFunction> void addDynamic(String string, Type type, Supplier<T> supplier) {
            this.addDynamicFunction(string, type, supplier);
        }

        public void addDynamicFunction(String string2, Type type2, Supplier<? extends TypedFunction> supplier) {
            this.dynamicFunctions.computeIfAbsent(string2, string -> new Object2ObjectLinkedOpenHashMap()).computeIfAbsent(type2, type -> new ObjectArrayList()).add(supplier);
        }

        public void addFunction(String string2, TypedFunction typedFunction) {
            this.functions.computeIfAbsent(string2, string -> new ObjectArrayList()).add(typedFunction);
        }

        public FunctionResolver build() {
            Object2ObjectLinkedOpenHashMap object2ObjectLinkedOpenHashMap = new Object2ObjectLinkedOpenHashMap();
            for (Map.Entry<String, List<TypedFunction>> entry : this.functions.entrySet()) {
                Object2ObjectLinkedOpenHashMap object2ObjectLinkedOpenHashMap2 = new Object2ObjectLinkedOpenHashMap();
                for (TypedFunction typedFunction : entry.getValue()) {
                    object2ObjectLinkedOpenHashMap2.computeIfAbsent(typedFunction.getReturnType(), type -> new ObjectArrayList()).add(typedFunction);
                }
                object2ObjectLinkedOpenHashMap.put(entry.getKey(), object2ObjectLinkedOpenHashMap2);
            }
            return new FunctionResolver((Map<String, Map<Type, List<TypedFunction>>>)object2ObjectLinkedOpenHashMap, this.dynamicFunctions);
        }
    }
}

